/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;

final class ConstantBitrateSeeker
implements Mp3Extractor.Seeker {
    private static final int BITS_PER_BYTE = 8;
    private final long firstFramePosition;
    private final int bitrate;
    private final long durationUs;

    public ConstantBitrateSeeker(long firstFramePosition, int bitrate, long inputLength) {
        this.firstFramePosition = firstFramePosition;
        this.bitrate = bitrate;
        this.durationUs = inputLength == -1L ? -9223372036854775807L : this.getTimeUs(inputLength);
    }

    @Override
    public boolean isSeekable() {
        return this.durationUs != -9223372036854775807L;
    }

    @Override
    public long getPosition(long timeUs) {
        return this.durationUs == -9223372036854775807L ? 0L : this.firstFramePosition + timeUs * (long)this.bitrate / 8000000L;
    }

    @Override
    public long getTimeUs(long position) {
        return Math.max(0L, position - this.firstFramePosition) * 1000000L * 8L / (long)this.bitrate;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }
}

