/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

public final class TimestampAdjuster {
    public static final long DO_NOT_OFFSET = Long.MAX_VALUE;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    private final long firstSampleTimestampUs;
    private long timestampOffsetUs;
    private volatile long lastSampleTimestamp;

    public TimestampAdjuster(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.lastSampleTimestamp = -9223372036854775807L;
    }

    public void reset() {
        this.lastSampleTimestamp = -9223372036854775807L;
    }

    public long adjustTsTimestamp(long pts) {
        if (this.lastSampleTimestamp != -9223372036854775807L) {
            long lastPts = TimestampAdjuster.usToPts(this.lastSampleTimestamp);
            long closestWrapCount = (lastPts + 0x100000000L) / 0x200000000L;
            long ptsWrapBelow = pts + 0x200000000L * (closestWrapCount - 1L);
            long ptsWrapAbove = pts + 0x200000000L * closestWrapCount;
            pts = Math.abs(ptsWrapBelow - lastPts) < Math.abs(ptsWrapAbove - lastPts) ? ptsWrapBelow : ptsWrapAbove;
        }
        return this.adjustSampleTimestamp(TimestampAdjuster.ptsToUs(pts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long adjustSampleTimestamp(long timeUs) {
        if (this.lastSampleTimestamp != -9223372036854775807L) {
            this.lastSampleTimestamp = timeUs;
        } else {
            if (this.firstSampleTimestampUs != Long.MAX_VALUE) {
                this.timestampOffsetUs = this.firstSampleTimestampUs - timeUs;
            }
            TimestampAdjuster timestampAdjuster = this;
            synchronized (timestampAdjuster) {
                this.lastSampleTimestamp = timeUs;
                this.notifyAll();
            }
        }
        return timeUs + this.timestampOffsetUs;
    }

    public synchronized void waitUntilInitialized() throws InterruptedException {
        while (this.lastSampleTimestamp == -9223372036854775807L) {
            this.wait();
        }
    }

    public static long ptsToUs(long pts) {
        return pts * 1000000L / 90000L;
    }

    public static long usToPts(long us) {
        return us * 90000L / 1000000L;
    }
}

