/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.upstream.Allocation;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultTrackOutput
implements TrackOutput {
    private static final int INITIAL_SCRATCH_SIZE = 32;
    private static final int STATE_ENABLED = 0;
    private static final int STATE_ENABLED_WRITING = 1;
    private static final int STATE_DISABLED = 2;
    private final Allocator allocator;
    private final int allocationLength;
    private final InfoQueue infoQueue;
    private final LinkedBlockingDeque<Allocation> dataQueue;
    private final BufferExtrasHolder extrasHolder;
    private final ParsableByteArray scratch;
    private final AtomicInteger state;
    private long totalBytesDropped;
    private Format downstreamFormat;
    private long sampleOffsetUs;
    private long totalBytesWritten;
    private Allocation lastAllocation;
    private int lastAllocationOffset;
    private boolean needKeyframe;
    private boolean pendingSplice;
    private UpstreamFormatChangedListener upstreamFormatChangeListener;

    public DefaultTrackOutput(Allocator allocator) {
        this.allocator = allocator;
        this.allocationLength = allocator.getIndividualAllocationLength();
        this.infoQueue = new InfoQueue();
        this.dataQueue = new LinkedBlockingDeque();
        this.extrasHolder = new BufferExtrasHolder();
        this.scratch = new ParsableByteArray(32);
        this.state = new AtomicInteger();
        this.lastAllocationOffset = this.allocationLength;
        this.needKeyframe = true;
    }

    public void reset(boolean enable) {
        int previousState = this.state.getAndSet(enable ? 0 : 2);
        this.clearSampleData();
        this.infoQueue.resetLargestParsedTimestamps();
        if (previousState == 2) {
            this.downstreamFormat = null;
        }
    }

    public void sourceId(int sourceId) {
        this.infoQueue.sourceId(sourceId);
    }

    public void splice() {
        this.pendingSplice = true;
    }

    public int getWriteIndex() {
        return this.infoQueue.getWriteIndex();
    }

    public void discardUpstreamSamples(int discardFromIndex) {
        this.totalBytesWritten = this.infoQueue.discardUpstreamSamples(discardFromIndex);
        this.dropUpstreamFrom(this.totalBytesWritten);
    }

    private void dropUpstreamFrom(long absolutePosition) {
        int relativePosition = (int)(absolutePosition - this.totalBytesDropped);
        int allocationIndex = relativePosition / this.allocationLength;
        int allocationOffset = relativePosition % this.allocationLength;
        int allocationDiscardCount = this.dataQueue.size() - allocationIndex - 1;
        if (allocationOffset == 0) {
            ++allocationDiscardCount;
        }
        for (int i = 0; i < allocationDiscardCount; ++i) {
            this.allocator.release(this.dataQueue.removeLast());
        }
        this.lastAllocation = this.dataQueue.peekLast();
        this.lastAllocationOffset = allocationOffset == 0 ? this.allocationLength : allocationOffset;
    }

    public void disable() {
        if (this.state.getAndSet(2) == 0) {
            this.clearSampleData();
        }
    }

    public boolean isEmpty() {
        return this.infoQueue.isEmpty();
    }

    public int getReadIndex() {
        return this.infoQueue.getReadIndex();
    }

    public int peekSourceId() {
        return this.infoQueue.peekSourceId();
    }

    public Format getUpstreamFormat() {
        return this.infoQueue.getUpstreamFormat();
    }

    public long getLargestQueuedTimestampUs() {
        return this.infoQueue.getLargestQueuedTimestampUs();
    }

    public boolean skipToKeyframeBefore(long timeUs) {
        long nextOffset = this.infoQueue.skipToKeyframeBefore(timeUs);
        if (nextOffset == -1L) {
            return false;
        }
        this.dropDownstreamTo(nextOffset);
        return true;
    }

    public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean loadingFinished, long decodeOnlyUntilUs) {
        switch (this.infoQueue.readData(formatHolder, buffer, this.downstreamFormat, this.extrasHolder)) {
            case -3: {
                if (loadingFinished) {
                    buffer.setFlags(4);
                    return -4;
                }
                return -3;
            }
            case -5: {
                this.downstreamFormat = formatHolder.format;
                return -5;
            }
            case -4: {
                if (buffer.timeUs < decodeOnlyUntilUs) {
                    buffer.addFlag(Integer.MIN_VALUE);
                }
                if (buffer.isEncrypted()) {
                    this.readEncryptionData(buffer, this.extrasHolder);
                }
                buffer.ensureSpaceForWrite(this.extrasHolder.size);
                this.readData(this.extrasHolder.offset, buffer.data, this.extrasHolder.size);
                this.dropDownstreamTo(this.extrasHolder.nextOffset);
                return -4;
            }
        }
        throw new IllegalStateException();
    }

    private void readEncryptionData(DecoderInputBuffer buffer, BufferExtrasHolder extrasHolder) {
        int[] encryptedDataSizes;
        int subsampleCount;
        long offset = extrasHolder.offset;
        this.scratch.reset(1);
        this.readData(offset, this.scratch.data, 1);
        ++offset;
        byte signalByte = this.scratch.data[0];
        boolean subsampleEncryption = (signalByte & 0x80) != 0;
        int ivSize = signalByte & 0x7F;
        if (buffer.cryptoInfo.iv == null) {
            buffer.cryptoInfo.iv = new byte[16];
        }
        this.readData(offset, buffer.cryptoInfo.iv, ivSize);
        offset += (long)ivSize;
        if (subsampleEncryption) {
            this.scratch.reset(2);
            this.readData(offset, this.scratch.data, 2);
            offset += 2L;
            subsampleCount = this.scratch.readUnsignedShort();
        } else {
            subsampleCount = 1;
        }
        int[] clearDataSizes = buffer.cryptoInfo.numBytesOfClearData;
        if (clearDataSizes == null || clearDataSizes.length < subsampleCount) {
            clearDataSizes = new int[subsampleCount];
        }
        if ((encryptedDataSizes = buffer.cryptoInfo.numBytesOfEncryptedData) == null || encryptedDataSizes.length < subsampleCount) {
            encryptedDataSizes = new int[subsampleCount];
        }
        if (subsampleEncryption) {
            int subsampleDataLength = 6 * subsampleCount;
            this.scratch.reset(subsampleDataLength);
            this.readData(offset, this.scratch.data, subsampleDataLength);
            offset += (long)subsampleDataLength;
            this.scratch.setPosition(0);
            for (int i = 0; i < subsampleCount; ++i) {
                clearDataSizes[i] = this.scratch.readUnsignedShort();
                encryptedDataSizes[i] = this.scratch.readUnsignedIntToInt();
            }
        } else {
            clearDataSizes[0] = 0;
            encryptedDataSizes[0] = extrasHolder.size - (int)(offset - extrasHolder.offset);
        }
        buffer.cryptoInfo.set(subsampleCount, clearDataSizes, encryptedDataSizes, extrasHolder.encryptionKeyId, buffer.cryptoInfo.iv, 1);
        int bytesRead = (int)(offset - extrasHolder.offset);
        extrasHolder.offset += (long)bytesRead;
        extrasHolder.size -= bytesRead;
    }

    private void readData(long absolutePosition, ByteBuffer target, int length) {
        int toCopy;
        for (int remaining = length; remaining > 0; remaining -= toCopy) {
            this.dropDownstreamTo(absolutePosition);
            int positionInAllocation = (int)(absolutePosition - this.totalBytesDropped);
            toCopy = Math.min(remaining, this.allocationLength - positionInAllocation);
            Allocation allocation = this.dataQueue.peek();
            target.put(allocation.data, allocation.translateOffset(positionInAllocation), toCopy);
            absolutePosition += (long)toCopy;
        }
    }

    private void readData(long absolutePosition, byte[] target, int length) {
        int toCopy;
        for (int bytesRead = 0; bytesRead < length; bytesRead += toCopy) {
            this.dropDownstreamTo(absolutePosition);
            int positionInAllocation = (int)(absolutePosition - this.totalBytesDropped);
            toCopy = Math.min(length - bytesRead, this.allocationLength - positionInAllocation);
            Allocation allocation = this.dataQueue.peek();
            System.arraycopy(allocation.data, allocation.translateOffset(positionInAllocation), target, bytesRead, toCopy);
            absolutePosition += (long)toCopy;
        }
    }

    private void dropDownstreamTo(long absolutePosition) {
        int relativePosition = (int)(absolutePosition - this.totalBytesDropped);
        int allocationIndex = relativePosition / this.allocationLength;
        for (int i = 0; i < allocationIndex; ++i) {
            this.allocator.release(this.dataQueue.remove());
            this.totalBytesDropped += (long)this.allocationLength;
        }
    }

    public void setUpstreamFormatChangeListener(UpstreamFormatChangedListener listener) {
        this.upstreamFormatChangeListener = listener;
    }

    public void formatWithOffset(Format format, long sampleOffsetUs) {
        this.sampleOffsetUs = sampleOffsetUs;
        this.format(format);
    }

    @Override
    public void format(Format format) {
        Format adjustedFormat = DefaultTrackOutput.getAdjustedSampleFormat(format, this.sampleOffsetUs);
        boolean formatChanged = this.infoQueue.format(adjustedFormat);
        if (this.upstreamFormatChangeListener != null && formatChanged) {
            this.upstreamFormatChangeListener.onUpstreamFormatChanged(adjustedFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        if (!this.startWriteOperation()) {
            int bytesSkipped = input.skip(length);
            if (bytesSkipped == -1) {
                if (allowEndOfInput) {
                    return -1;
                }
                throw new EOFException();
            }
            return bytesSkipped;
        }
        try {
            length = this.prepareForAppend(length);
            int bytesAppended = input.read(this.lastAllocation.data, this.lastAllocation.translateOffset(this.lastAllocationOffset), length);
            if (bytesAppended == -1) {
                if (allowEndOfInput) {
                    int n = -1;
                    return n;
                }
                throw new EOFException();
            }
            this.lastAllocationOffset += bytesAppended;
            this.totalBytesWritten += (long)bytesAppended;
            int n = bytesAppended;
            return n;
        }
        finally {
            this.endWriteOperation();
        }
    }

    @Override
    public void sampleData(ParsableByteArray buffer, int length) {
        if (!this.startWriteOperation()) {
            buffer.skipBytes(length);
            return;
        }
        while (length > 0) {
            int thisAppendLength = this.prepareForAppend(length);
            buffer.readBytes(this.lastAllocation.data, this.lastAllocation.translateOffset(this.lastAllocationOffset), thisAppendLength);
            this.lastAllocationOffset += thisAppendLength;
            this.totalBytesWritten += (long)thisAppendLength;
            length -= thisAppendLength;
        }
        this.endWriteOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
        if (!this.startWriteOperation()) {
            this.infoQueue.commitSampleTimestamp(timeUs);
            return;
        }
        try {
            if (this.pendingSplice) {
                if ((flags & 1) == 0 || !this.infoQueue.attemptSplice(timeUs)) {
                    return;
                }
                this.pendingSplice = false;
            }
            if (this.needKeyframe) {
                if ((flags & 1) == 0) {
                    return;
                }
                this.needKeyframe = false;
            }
            long absoluteOffset = this.totalBytesWritten - (long)size - (long)offset;
            this.infoQueue.commitSample(timeUs += this.sampleOffsetUs, flags, absoluteOffset, size, encryptionKey);
        }
        finally {
            this.endWriteOperation();
        }
    }

    private boolean startWriteOperation() {
        return this.state.compareAndSet(0, 1);
    }

    private void endWriteOperation() {
        if (!this.state.compareAndSet(1, 0)) {
            this.clearSampleData();
        }
    }

    private void clearSampleData() {
        this.infoQueue.clearSampleData();
        this.allocator.release(this.dataQueue.toArray(new Allocation[this.dataQueue.size()]));
        this.dataQueue.clear();
        this.allocator.trim();
        this.totalBytesDropped = 0L;
        this.totalBytesWritten = 0L;
        this.lastAllocation = null;
        this.lastAllocationOffset = this.allocationLength;
        this.needKeyframe = true;
    }

    private int prepareForAppend(int length) {
        if (this.lastAllocationOffset == this.allocationLength) {
            this.lastAllocationOffset = 0;
            this.lastAllocation = this.allocator.allocate();
            this.dataQueue.add(this.lastAllocation);
        }
        return Math.min(length, this.allocationLength - this.lastAllocationOffset);
    }

    private static Format getAdjustedSampleFormat(Format format, long sampleOffsetUs) {
        if (format == null) {
            return null;
        }
        if (sampleOffsetUs != 0L && format.subsampleOffsetUs != Long.MAX_VALUE) {
            format = format.copyWithSubsampleOffsetUs(format.subsampleOffsetUs + sampleOffsetUs);
        }
        return format;
    }

    private static final class BufferExtrasHolder {
        public int size;
        public long offset;
        public long nextOffset;
        public byte[] encryptionKeyId;

        private BufferExtrasHolder() {
        }
    }

    private static final class InfoQueue {
        private static final int SAMPLE_CAPACITY_INCREMENT = 1000;
        private int capacity = 1000;
        private int[] sourceIds = new int[this.capacity];
        private long[] offsets = new long[this.capacity];
        private int[] sizes;
        private int[] flags;
        private long[] timesUs = new long[this.capacity];
        private byte[][] encryptionKeys;
        private Format[] formats;
        private int queueSize;
        private int absoluteReadIndex;
        private int relativeReadIndex;
        private int relativeWriteIndex;
        private long largestDequeuedTimestampUs;
        private long largestQueuedTimestampUs;
        private boolean upstreamFormatRequired = true;
        private Format upstreamFormat;
        private int upstreamSourceId;

        public InfoQueue() {
            this.flags = new int[this.capacity];
            this.sizes = new int[this.capacity];
            this.encryptionKeys = new byte[this.capacity][];
            this.formats = new Format[this.capacity];
            this.largestDequeuedTimestampUs = Long.MIN_VALUE;
            this.largestQueuedTimestampUs = Long.MIN_VALUE;
        }

        public void clearSampleData() {
            this.absoluteReadIndex = 0;
            this.relativeReadIndex = 0;
            this.relativeWriteIndex = 0;
            this.queueSize = 0;
        }

        public void resetLargestParsedTimestamps() {
            this.largestDequeuedTimestampUs = Long.MIN_VALUE;
            this.largestQueuedTimestampUs = Long.MIN_VALUE;
        }

        public int getWriteIndex() {
            return this.absoluteReadIndex + this.queueSize;
        }

        public long discardUpstreamSamples(int discardFromIndex) {
            int discardCount = this.getWriteIndex() - discardFromIndex;
            Assertions.checkArgument(0 <= discardCount && discardCount <= this.queueSize);
            if (discardCount == 0) {
                if (this.absoluteReadIndex == 0) {
                    return 0L;
                }
                int lastWriteIndex = (this.relativeWriteIndex == 0 ? this.capacity : this.relativeWriteIndex) - 1;
                return this.offsets[lastWriteIndex] + (long)this.sizes[lastWriteIndex];
            }
            this.queueSize -= discardCount;
            this.relativeWriteIndex = (this.relativeWriteIndex + this.capacity - discardCount) % this.capacity;
            this.largestQueuedTimestampUs = Long.MIN_VALUE;
            for (int i = this.queueSize - 1; i >= 0; --i) {
                int sampleIndex = (this.relativeReadIndex + i) % this.capacity;
                this.largestQueuedTimestampUs = Math.max(this.largestQueuedTimestampUs, this.timesUs[sampleIndex]);
                if ((this.flags[sampleIndex] & 1) != 0) break;
            }
            return this.offsets[this.relativeWriteIndex];
        }

        public void sourceId(int sourceId) {
            this.upstreamSourceId = sourceId;
        }

        public int getReadIndex() {
            return this.absoluteReadIndex;
        }

        public int peekSourceId() {
            return this.queueSize == 0 ? this.upstreamSourceId : this.sourceIds[this.relativeReadIndex];
        }

        public synchronized boolean isEmpty() {
            return this.queueSize == 0;
        }

        public synchronized Format getUpstreamFormat() {
            return this.upstreamFormatRequired ? null : this.upstreamFormat;
        }

        public synchronized long getLargestQueuedTimestampUs() {
            return Math.max(this.largestDequeuedTimestampUs, this.largestQueuedTimestampUs);
        }

        public synchronized int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, Format downstreamFormat, BufferExtrasHolder extrasHolder) {
            if (this.queueSize == 0) {
                if (this.upstreamFormat != null && this.upstreamFormat != downstreamFormat) {
                    formatHolder.format = this.upstreamFormat;
                    return -5;
                }
                return -3;
            }
            if (this.formats[this.relativeReadIndex] != downstreamFormat) {
                formatHolder.format = this.formats[this.relativeReadIndex];
                return -5;
            }
            buffer.timeUs = this.timesUs[this.relativeReadIndex];
            buffer.setFlags(this.flags[this.relativeReadIndex]);
            extrasHolder.size = this.sizes[this.relativeReadIndex];
            extrasHolder.offset = this.offsets[this.relativeReadIndex];
            extrasHolder.encryptionKeyId = this.encryptionKeys[this.relativeReadIndex];
            this.largestDequeuedTimestampUs = Math.max(this.largestDequeuedTimestampUs, buffer.timeUs);
            --this.queueSize;
            ++this.relativeReadIndex;
            ++this.absoluteReadIndex;
            if (this.relativeReadIndex == this.capacity) {
                this.relativeReadIndex = 0;
            }
            extrasHolder.nextOffset = this.queueSize > 0 ? this.offsets[this.relativeReadIndex] : extrasHolder.offset + (long)extrasHolder.size;
            return -4;
        }

        public synchronized long skipToKeyframeBefore(long timeUs) {
            if (this.queueSize == 0 || timeUs < this.timesUs[this.relativeReadIndex]) {
                return -1L;
            }
            int lastWriteIndex = (this.relativeWriteIndex == 0 ? this.capacity : this.relativeWriteIndex) - 1;
            long lastTimeUs = this.timesUs[lastWriteIndex];
            if (timeUs > lastTimeUs) {
                return -1L;
            }
            int sampleCount = 0;
            int sampleCountToKeyframe = -1;
            int searchIndex = this.relativeReadIndex;
            while (searchIndex != this.relativeWriteIndex && this.timesUs[searchIndex] <= timeUs) {
                if ((this.flags[searchIndex] & 1) != 0) {
                    sampleCountToKeyframe = sampleCount;
                }
                searchIndex = (searchIndex + 1) % this.capacity;
                ++sampleCount;
            }
            if (sampleCountToKeyframe == -1) {
                return -1L;
            }
            this.queueSize -= sampleCountToKeyframe;
            this.relativeReadIndex = (this.relativeReadIndex + sampleCountToKeyframe) % this.capacity;
            this.absoluteReadIndex += sampleCountToKeyframe;
            return this.offsets[this.relativeReadIndex];
        }

        public synchronized boolean format(Format format) {
            if (format == null) {
                this.upstreamFormatRequired = true;
                return false;
            }
            this.upstreamFormatRequired = false;
            if (Util.areEqual(format, this.upstreamFormat)) {
                return false;
            }
            this.upstreamFormat = format;
            return true;
        }

        public synchronized void commitSample(long timeUs, int sampleFlags, long offset, int size, byte[] encryptionKey) {
            Assertions.checkState(!this.upstreamFormatRequired);
            this.commitSampleTimestamp(timeUs);
            this.timesUs[this.relativeWriteIndex] = timeUs;
            this.offsets[this.relativeWriteIndex] = offset;
            this.sizes[this.relativeWriteIndex] = size;
            this.flags[this.relativeWriteIndex] = sampleFlags;
            this.encryptionKeys[this.relativeWriteIndex] = encryptionKey;
            this.formats[this.relativeWriteIndex] = this.upstreamFormat;
            this.sourceIds[this.relativeWriteIndex] = this.upstreamSourceId;
            ++this.queueSize;
            if (this.queueSize == this.capacity) {
                int newCapacity = this.capacity + 1000;
                int[] newSourceIds = new int[newCapacity];
                long[] newOffsets = new long[newCapacity];
                long[] newTimesUs = new long[newCapacity];
                int[] newFlags = new int[newCapacity];
                int[] newSizes = new int[newCapacity];
                byte[][] newEncryptionKeys = new byte[newCapacity][];
                Format[] newFormats = new Format[newCapacity];
                int beforeWrap = this.capacity - this.relativeReadIndex;
                System.arraycopy(this.offsets, this.relativeReadIndex, newOffsets, 0, beforeWrap);
                System.arraycopy(this.timesUs, this.relativeReadIndex, newTimesUs, 0, beforeWrap);
                System.arraycopy(this.flags, this.relativeReadIndex, newFlags, 0, beforeWrap);
                System.arraycopy(this.sizes, this.relativeReadIndex, newSizes, 0, beforeWrap);
                System.arraycopy(this.encryptionKeys, this.relativeReadIndex, newEncryptionKeys, 0, beforeWrap);
                System.arraycopy(this.formats, this.relativeReadIndex, newFormats, 0, beforeWrap);
                System.arraycopy(this.sourceIds, this.relativeReadIndex, newSourceIds, 0, beforeWrap);
                int afterWrap = this.relativeReadIndex;
                System.arraycopy(this.offsets, 0, newOffsets, beforeWrap, afterWrap);
                System.arraycopy(this.timesUs, 0, newTimesUs, beforeWrap, afterWrap);
                System.arraycopy(this.flags, 0, newFlags, beforeWrap, afterWrap);
                System.arraycopy(this.sizes, 0, newSizes, beforeWrap, afterWrap);
                System.arraycopy(this.encryptionKeys, 0, newEncryptionKeys, beforeWrap, afterWrap);
                System.arraycopy(this.formats, 0, newFormats, beforeWrap, afterWrap);
                System.arraycopy(this.sourceIds, 0, newSourceIds, beforeWrap, afterWrap);
                this.offsets = newOffsets;
                this.timesUs = newTimesUs;
                this.flags = newFlags;
                this.sizes = newSizes;
                this.encryptionKeys = newEncryptionKeys;
                this.formats = newFormats;
                this.sourceIds = newSourceIds;
                this.relativeReadIndex = 0;
                this.relativeWriteIndex = this.capacity;
                this.queueSize = this.capacity;
                this.capacity = newCapacity;
            } else {
                ++this.relativeWriteIndex;
                if (this.relativeWriteIndex == this.capacity) {
                    this.relativeWriteIndex = 0;
                }
            }
        }

        public synchronized void commitSampleTimestamp(long timeUs) {
            this.largestQueuedTimestampUs = Math.max(this.largestQueuedTimestampUs, timeUs);
        }

        public synchronized boolean attemptSplice(long timeUs) {
            int retainCount;
            if (this.largestDequeuedTimestampUs >= timeUs) {
                return false;
            }
            for (retainCount = this.queueSize; retainCount > 0 && this.timesUs[(this.relativeReadIndex + retainCount - 1) % this.capacity] >= timeUs; --retainCount) {
            }
            this.discardUpstreamSamples(this.absoluteReadIndex + retainCount);
            return true;
        }
    }

    public static interface UpstreamFormatChangedListener {
        public void onUpstreamFormatChanged(Format var1);
    }
}

