/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.util.Util;

public final class ChunkIndex
implements SeekMap {
    public final int length;
    public final int[] sizes;
    public final long[] offsets;
    public final long[] durationsUs;
    public final long[] timesUs;
    private final long durationUs;

    public ChunkIndex(int[] sizes, long[] offsets, long[] durationsUs, long[] timesUs) {
        this.sizes = sizes;
        this.offsets = offsets;
        this.durationsUs = durationsUs;
        this.timesUs = timesUs;
        this.length = sizes.length;
        this.durationUs = durationsUs[this.length - 1] + timesUs[this.length - 1];
    }

    public int getChunkIndex(long timeUs) {
        return Util.binarySearchFloor(this.timesUs, timeUs, true, true);
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public long getPosition(long timeUs) {
        return this.offsets[this.getChunkIndex(timeUs)];
    }
}

