/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.KeysExpiredException;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.HashMap;
import java.util.UUID;

@TargetApi(value=18)
public class StreamingDrmSessionManager<T extends ExoMediaCrypto>
implements DrmSessionManager<T>,
DrmSession<T> {
    public static final String PLAYREADY_CUSTOM_DATA_KEY = "PRCustomData";
    private static final int MSG_PROVISION = 0;
    private static final int MSG_KEYS = 1;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final ExoMediaDrm<T> mediaDrm;
    private final HashMap<String, String> optionalKeyRequestParameters;
    final MediaDrmCallback callback;
    final UUID uuid;
    MediaDrmHandler mediaDrmHandler;
    PostResponseHandler postResponseHandler;
    private Looper playbackLooper;
    private HandlerThread requestHandlerThread;
    private Handler postRequestHandler;
    private int openCount;
    private boolean provisioningInProgress;
    private int state;
    private T mediaCrypto;
    private Exception lastException;
    private DrmInitData.SchemeData schemeData;
    private byte[] sessionId;

    public static StreamingDrmSessionManager<FrameworkMediaCrypto> newWidevineInstance(MediaDrmCallback callback, HashMap<String, String> optionalKeyRequestParameters, Handler eventHandler, EventListener eventListener) throws UnsupportedDrmException {
        return StreamingDrmSessionManager.newFrameworkInstance(C.WIDEVINE_UUID, callback, optionalKeyRequestParameters, eventHandler, eventListener);
    }

    public static StreamingDrmSessionManager<FrameworkMediaCrypto> newPlayReadyInstance(MediaDrmCallback callback, String customData, Handler eventHandler, EventListener eventListener) throws UnsupportedDrmException {
        HashMap<String, String> optionalKeyRequestParameters;
        if (!TextUtils.isEmpty((CharSequence)customData)) {
            optionalKeyRequestParameters = new HashMap<String, String>();
            optionalKeyRequestParameters.put(PLAYREADY_CUSTOM_DATA_KEY, customData);
        } else {
            optionalKeyRequestParameters = null;
        }
        return StreamingDrmSessionManager.newFrameworkInstance(C.PLAYREADY_UUID, callback, optionalKeyRequestParameters, eventHandler, eventListener);
    }

    public static StreamingDrmSessionManager<FrameworkMediaCrypto> newFrameworkInstance(UUID uuid, MediaDrmCallback callback, HashMap<String, String> optionalKeyRequestParameters, Handler eventHandler, EventListener eventListener) throws UnsupportedDrmException {
        return new StreamingDrmSessionManager<FrameworkMediaCrypto>(uuid, FrameworkMediaDrm.newInstance(uuid), callback, optionalKeyRequestParameters, eventHandler, eventListener);
    }

    public StreamingDrmSessionManager(UUID uuid, ExoMediaDrm<T> mediaDrm, MediaDrmCallback callback, HashMap<String, String> optionalKeyRequestParameters, Handler eventHandler, EventListener eventListener) {
        this.uuid = uuid;
        this.mediaDrm = mediaDrm;
        this.callback = callback;
        this.optionalKeyRequestParameters = optionalKeyRequestParameters;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        mediaDrm.setOnEventListener(new MediaDrmEventListener());
        this.state = 1;
    }

    public final String getPropertyString(String key) {
        return this.mediaDrm.getPropertyString(key);
    }

    public final void setPropertyString(String key, String value) {
        this.mediaDrm.setPropertyString(key, value);
    }

    public final byte[] getPropertyByteArray(String key) {
        return this.mediaDrm.getPropertyByteArray(key);
    }

    public final void setPropertyByteArray(String key, byte[] value) {
        this.mediaDrm.setPropertyByteArray(key, value);
    }

    @Override
    public DrmSession<T> acquireSession(Looper playbackLooper, DrmInitData drmInitData) {
        byte[] psshData;
        Assertions.checkState(this.playbackLooper == null || this.playbackLooper == playbackLooper);
        if (++this.openCount != 1) {
            return this;
        }
        if (this.playbackLooper == null) {
            this.playbackLooper = playbackLooper;
            this.mediaDrmHandler = new MediaDrmHandler(playbackLooper);
            this.postResponseHandler = new PostResponseHandler(playbackLooper);
        }
        this.requestHandlerThread = new HandlerThread("DrmRequestHandler");
        this.requestHandlerThread.start();
        this.postRequestHandler = new PostRequestHandler(this.requestHandlerThread.getLooper());
        this.schemeData = drmInitData.get(this.uuid);
        if (this.schemeData == null) {
            this.onError(new IllegalStateException("Media does not support uuid: " + this.uuid));
            return this;
        }
        if (Util.SDK_INT < 21 && (psshData = PsshAtomUtil.parseSchemeSpecificData(this.schemeData.data, C.WIDEVINE_UUID)) != null) {
            this.schemeData = new DrmInitData.SchemeData(C.WIDEVINE_UUID, this.schemeData.mimeType, psshData);
        }
        this.state = 2;
        this.openInternal(true);
        return this;
    }

    @Override
    public void releaseSession(DrmSession<T> session) {
        if (--this.openCount != 0) {
            return;
        }
        this.state = 1;
        this.provisioningInProgress = false;
        this.mediaDrmHandler.removeCallbacksAndMessages(null);
        this.postResponseHandler.removeCallbacksAndMessages(null);
        this.postRequestHandler.removeCallbacksAndMessages(null);
        this.postRequestHandler = null;
        this.requestHandlerThread.quit();
        this.requestHandlerThread = null;
        this.schemeData = null;
        this.mediaCrypto = null;
        this.lastException = null;
        if (this.sessionId != null) {
            this.mediaDrm.closeSession(this.sessionId);
            this.sessionId = null;
        }
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final T getMediaCrypto() {
        if (this.state != 3 && this.state != 4) {
            throw new IllegalStateException();
        }
        return this.mediaCrypto;
    }

    @Override
    public boolean requiresSecureDecoderComponent(String mimeType) {
        if (this.state != 3 && this.state != 4) {
            throw new IllegalStateException();
        }
        return this.mediaCrypto.requiresSecureDecoderComponent(mimeType);
    }

    @Override
    public final Exception getError() {
        return this.state == 0 ? this.lastException : null;
    }

    private void openInternal(boolean allowProvisioning) {
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.mediaCrypto = this.mediaDrm.createMediaCrypto(this.uuid, this.sessionId);
            this.state = 3;
            this.postKeyRequest();
        }
        catch (NotProvisionedException e) {
            if (allowProvisioning) {
                this.postProvisionRequest();
            } else {
                this.onError((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    private void postProvisionRequest() {
        if (this.provisioningInProgress) {
            return;
        }
        this.provisioningInProgress = true;
        ExoMediaDrm.ProvisionRequest request = this.mediaDrm.getProvisionRequest();
        this.postRequestHandler.obtainMessage(0, (Object)request).sendToTarget();
    }

    private void onProvisionResponse(Object response) {
        this.provisioningInProgress = false;
        if (this.state != 2 && this.state != 3 && this.state != 4) {
            return;
        }
        if (response instanceof Exception) {
            this.onError((Exception)response);
            return;
        }
        try {
            this.mediaDrm.provideProvisionResponse((byte[])response);
            if (this.state == 2) {
                this.openInternal(false);
            } else {
                this.postKeyRequest();
            }
        }
        catch (DeniedByServerException e) {
            this.onError((Exception)((Object)e));
        }
    }

    private void postKeyRequest() {
        try {
            ExoMediaDrm.KeyRequest keyRequest = this.mediaDrm.getKeyRequest(this.sessionId, this.schemeData.data, this.schemeData.mimeType, 1, this.optionalKeyRequestParameters);
            this.postRequestHandler.obtainMessage(1, (Object)keyRequest).sendToTarget();
        }
        catch (NotProvisionedException e) {
            this.onKeysError((Exception)((Object)e));
        }
    }

    private void onKeyResponse(Object response) {
        if (this.state != 3 && this.state != 4) {
            return;
        }
        if (response instanceof Exception) {
            this.onKeysError((Exception)response);
            return;
        }
        try {
            this.mediaDrm.provideKeyResponse(this.sessionId, (byte[])response);
            this.state = 4;
            if (this.eventHandler != null && this.eventListener != null) {
                this.eventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        StreamingDrmSessionManager.this.eventListener.onDrmKeysLoaded();
                    }
                });
            }
        }
        catch (Exception e) {
            this.onKeysError(e);
        }
    }

    private void onKeysError(Exception e) {
        if (e instanceof NotProvisionedException) {
            this.postProvisionRequest();
        } else {
            this.onError(e);
        }
    }

    private void onError(final Exception e) {
        this.lastException = e;
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    StreamingDrmSessionManager.this.eventListener.onDrmSessionManagerError(e);
                }
            });
        }
        if (this.state != 4) {
            this.state = 0;
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostRequestHandler
    extends Handler {
        public PostRequestHandler(Looper backgroundLooper) {
            super(backgroundLooper);
        }

        public void handleMessage(Message msg) {
            Object response;
            try {
                switch (msg.what) {
                    case 0: {
                        response = StreamingDrmSessionManager.this.callback.executeProvisionRequest(StreamingDrmSessionManager.this.uuid, (ExoMediaDrm.ProvisionRequest)msg.obj);
                        break;
                    }
                    case 1: {
                        response = StreamingDrmSessionManager.this.callback.executeKeyRequest(StreamingDrmSessionManager.this.uuid, (ExoMediaDrm.KeyRequest)msg.obj);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception e) {
                response = e;
            }
            StreamingDrmSessionManager.this.postResponseHandler.obtainMessage(msg.what, response).sendToTarget();
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostResponseHandler
    extends Handler {
        public PostResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    StreamingDrmSessionManager.this.onProvisionResponse(msg.obj);
                    return;
                }
                case 1: {
                    StreamingDrmSessionManager.this.onKeyResponse(msg.obj);
                    return;
                }
            }
        }
    }

    private class MediaDrmEventListener
    implements ExoMediaDrm.OnEventListener<T> {
        private MediaDrmEventListener() {
        }

        @Override
        public void onEvent(ExoMediaDrm<? extends T> md, byte[] sessionId, int event, int extra, byte[] data) {
            StreamingDrmSessionManager.this.mediaDrmHandler.sendEmptyMessage(event);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MediaDrmHandler
    extends Handler {
        public MediaDrmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (StreamingDrmSessionManager.this.openCount == 0 || StreamingDrmSessionManager.this.state != 3 && StreamingDrmSessionManager.this.state != 4) {
                return;
            }
            switch (msg.what) {
                case 2: {
                    StreamingDrmSessionManager.this.postKeyRequest();
                    return;
                }
                case 3: {
                    StreamingDrmSessionManager.this.state = 3;
                    StreamingDrmSessionManager.this.onError(new KeysExpiredException());
                    return;
                }
                case 1: {
                    StreamingDrmSessionManager.this.state = 3;
                    StreamingDrmSessionManager.this.postProvisionRequest();
                    return;
                }
            }
        }
    }

    public static interface EventListener {
        public void onDrmKeysLoaded();

        public void onDrmSessionManagerError(Exception var1);
    }
}

