/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public final class DrmInitData
implements Comparator<SchemeData>,
Parcelable {
    private final SchemeData[] schemeDatas;
    private int hashCode;
    public final int schemeDataCount;
    public static final Parcelable.Creator<DrmInitData> CREATOR = new Parcelable.Creator<DrmInitData>(){

        public DrmInitData createFromParcel(Parcel in) {
            return new DrmInitData(in);
        }

        public DrmInitData[] newArray(int size) {
            return new DrmInitData[size];
        }
    };

    public DrmInitData(List<SchemeData> schemeDatas) {
        this(false, schemeDatas.toArray(new SchemeData[schemeDatas.size()]));
    }

    public DrmInitData(SchemeData ... schemeDatas) {
        this(true, schemeDatas);
    }

    private DrmInitData(boolean cloneSchemeDatas, SchemeData ... schemeDatas) {
        if (cloneSchemeDatas) {
            schemeDatas = (SchemeData[])schemeDatas.clone();
        }
        Arrays.sort(schemeDatas, this);
        for (int i = 1; i < schemeDatas.length; ++i) {
            if (!schemeDatas[i - 1].uuid.equals(schemeDatas[i].uuid)) continue;
            throw new IllegalArgumentException("Duplicate data for uuid: " + schemeDatas[i].uuid);
        }
        this.schemeDatas = schemeDatas;
        this.schemeDataCount = schemeDatas.length;
    }

    DrmInitData(Parcel in) {
        this.schemeDatas = (SchemeData[])in.createTypedArray(SchemeData.CREATOR);
        this.schemeDataCount = this.schemeDatas.length;
    }

    public SchemeData get(UUID uuid) {
        for (SchemeData schemeData : this.schemeDatas) {
            if (!schemeData.matches(uuid)) continue;
            return schemeData;
        }
        return null;
    }

    public SchemeData get(int index) {
        return this.schemeDatas[index];
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.schemeDatas);
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.schemeDatas, ((DrmInitData)obj).schemeDatas);
    }

    @Override
    public int compare(SchemeData first, SchemeData second) {
        return C.UUID_NIL.equals(first.uuid) ? (C.UUID_NIL.equals(second.uuid) ? 0 : 1) : first.uuid.compareTo(second.uuid);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedArray((Parcelable[])this.schemeDatas, 0);
    }

    public static final class SchemeData
    implements Parcelable {
        private int hashCode;
        private final UUID uuid;
        public final String mimeType;
        public final byte[] data;
        public final boolean requiresSecureDecryption;
        public static final Parcelable.Creator<SchemeData> CREATOR = new Parcelable.Creator<SchemeData>(){

            public SchemeData createFromParcel(Parcel in) {
                return new SchemeData(in);
            }

            public SchemeData[] newArray(int size) {
                return new SchemeData[size];
            }
        };

        public SchemeData(UUID uuid, String mimeType, byte[] data) {
            this(uuid, mimeType, data, false);
        }

        public SchemeData(UUID uuid, String mimeType, byte[] data, boolean requiresSecureDecryption) {
            this.uuid = Assertions.checkNotNull(uuid);
            this.mimeType = Assertions.checkNotNull(mimeType);
            this.data = Assertions.checkNotNull(data);
            this.requiresSecureDecryption = requiresSecureDecryption;
        }

        SchemeData(Parcel in) {
            this.uuid = new UUID(in.readLong(), in.readLong());
            this.mimeType = in.readString();
            this.data = in.createByteArray();
            this.requiresSecureDecryption = in.readByte() != 0;
        }

        public boolean matches(UUID schemeUuid) {
            return C.UUID_NIL.equals(this.uuid) || schemeUuid.equals(this.uuid);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemeData)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            SchemeData other = (SchemeData)obj;
            return this.mimeType.equals(other.mimeType) && Util.areEqual(this.uuid, other.uuid) && Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = this.uuid.hashCode();
                result = 31 * result + this.mimeType.hashCode();
                this.hashCode = result = 31 * result + Arrays.hashCode(this.data);
            }
            return this.hashCode;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.uuid.getMostSignificantBits());
            dest.writeLong(this.uuid.getLeastSignificantBits());
            dest.writeString(this.mimeType);
            dest.writeByteArray(this.data);
            dest.writeByte((byte)(this.requiresSecureDecryption ? 1 : 0));
        }
    }
}

