/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.media.PlaybackParams;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioDecoderException;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AudioTrack;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.decoder.SimpleDecoder;
import com.google.android.exoplayer2.decoder.SimpleOutputBuffer;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.TraceUtil;

public abstract class SimpleDecoderAudioRenderer
extends BaseRenderer
implements MediaClock {
    private final AudioRendererEventListener.EventDispatcher eventDispatcher;
    private final FormatHolder formatHolder;
    private DecoderCounters decoderCounters;
    private Format inputFormat;
    private SimpleDecoder<DecoderInputBuffer, ? extends SimpleOutputBuffer, ? extends AudioDecoderException> decoder;
    private DecoderInputBuffer inputBuffer;
    private SimpleOutputBuffer outputBuffer;
    private long currentPositionUs;
    private boolean allowPositionDiscontinuity;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private final AudioTrack audioTrack;
    private int audioSessionId;
    private boolean audioTrackHasData;
    private long lastFeedElapsedRealtimeMs;

    public SimpleDecoderAudioRenderer() {
        this(null, null);
    }

    public SimpleDecoderAudioRenderer(Handler eventHandler, AudioRendererEventListener eventListener) {
        this(eventHandler, eventListener, null, 3);
    }

    public SimpleDecoderAudioRenderer(Handler eventHandler, AudioRendererEventListener eventListener, AudioCapabilities audioCapabilities, int streamType) {
        super(1);
        this.eventDispatcher = new AudioRendererEventListener.EventDispatcher(eventHandler, eventListener);
        this.audioSessionId = 0;
        this.audioTrack = new AudioTrack(audioCapabilities, streamType);
        this.formatHolder = new FormatHolder();
    }

    @Override
    public MediaClock getMediaClock() {
        return this;
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            return;
        }
        if (this.inputFormat == null && !this.readFormat()) {
            return;
        }
        if (this.decoder == null) {
            try {
                long codecInitializingTimestamp = SystemClock.elapsedRealtime();
                TraceUtil.beginSection("createAudioDecoder");
                this.decoder = this.createDecoder(this.inputFormat);
                TraceUtil.endSection();
                long codecInitializedTimestamp = SystemClock.elapsedRealtime();
                this.eventDispatcher.decoderInitialized(this.decoder.getName(), codecInitializedTimestamp, codecInitializedTimestamp - codecInitializingTimestamp);
                ++this.decoderCounters.decoderInitCount;
            }
            catch (AudioDecoderException e) {
                throw ExoPlaybackException.createForRenderer(e, this.getIndex());
            }
        }
        try {
            TraceUtil.beginSection("drainAndFeed");
            while (this.drainOutputBuffer()) {
            }
            while (this.feedInputBuffer()) {
            }
            TraceUtil.endSection();
        }
        catch (AudioDecoderException | AudioTrack.InitializationException | AudioTrack.WriteException e) {
            throw ExoPlaybackException.createForRenderer(e, this.getIndex());
        }
        this.decoderCounters.ensureUpdated();
    }

    protected abstract SimpleDecoder<DecoderInputBuffer, ? extends SimpleOutputBuffer, ? extends AudioDecoderException> createDecoder(Format var1) throws AudioDecoderException;

    protected Format getOutputFormat() {
        return Format.createAudioSampleFormat(null, "audio/raw", null, -1, -1, this.inputFormat.channelCount, this.inputFormat.sampleRate, 2, null, null, 0, null);
    }

    private boolean drainOutputBuffer() throws AudioDecoderException, AudioTrack.InitializationException, AudioTrack.WriteException {
        if (this.outputStreamEnded) {
            return false;
        }
        if (this.outputBuffer == null) {
            this.outputBuffer = (SimpleOutputBuffer)this.decoder.dequeueOutputBuffer();
            if (this.outputBuffer == null) {
                return false;
            }
            this.decoderCounters.skippedOutputBufferCount += this.outputBuffer.skippedOutputBufferCount;
        }
        if (this.outputBuffer.isEndOfStream()) {
            this.outputStreamEnded = true;
            this.audioTrack.handleEndOfStream();
            this.outputBuffer.release();
            this.outputBuffer = null;
            return false;
        }
        if (!this.audioTrack.isInitialized()) {
            Format outputFormat = this.getOutputFormat();
            this.audioTrack.configure(outputFormat.sampleMimeType, outputFormat.channelCount, outputFormat.sampleRate, outputFormat.pcmEncoding, 0);
            if (this.audioSessionId == 0) {
                this.audioSessionId = this.audioTrack.initialize(0);
                this.eventDispatcher.audioSessionId(this.audioSessionId);
                this.onAudioSessionId(this.audioSessionId);
            } else {
                this.audioTrack.initialize(this.audioSessionId);
            }
            this.audioTrackHasData = false;
            if (this.getState() == 2) {
                this.audioTrack.play();
            }
        } else {
            boolean audioTrackHadData = this.audioTrackHasData;
            this.audioTrackHasData = this.audioTrack.hasPendingData();
            if (audioTrackHadData && !this.audioTrackHasData && this.getState() == 2) {
                long elapsedSinceLastFeedMs = SystemClock.elapsedRealtime() - this.lastFeedElapsedRealtimeMs;
                long bufferSizeMs = C.usToMs(this.audioTrack.getBufferSizeUs());
                this.eventDispatcher.audioTrackUnderrun(this.audioTrack.getBufferSize(), bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }
        int handleBufferResult = this.audioTrack.handleBuffer(this.outputBuffer.data, this.outputBuffer.timeUs);
        this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        if ((handleBufferResult & 1) != 0) {
            this.allowPositionDiscontinuity = true;
        }
        if ((handleBufferResult & 2) != 0) {
            ++this.decoderCounters.renderedOutputBufferCount;
            this.outputBuffer.release();
            this.outputBuffer = null;
            return true;
        }
        return false;
    }

    private boolean feedInputBuffer() throws AudioDecoderException {
        int result;
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputBuffer == null) {
            this.inputBuffer = this.decoder.dequeueInputBuffer();
            if (this.inputBuffer == null) {
                return false;
            }
        }
        if ((result = this.readSource(this.formatHolder, this.inputBuffer)) == -3) {
            return false;
        }
        if (result == -5) {
            this.onInputFormatChanged(this.formatHolder.format);
            return true;
        }
        if (this.inputBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            this.decoder.queueInputBuffer(this.inputBuffer);
            this.inputBuffer = null;
            return false;
        }
        this.inputBuffer.flip();
        this.decoder.queueInputBuffer(this.inputBuffer);
        ++this.decoderCounters.inputBufferCount;
        this.inputBuffer = null;
        return true;
    }

    private void flushDecoder() {
        this.inputBuffer = null;
        if (this.outputBuffer != null) {
            this.outputBuffer.release();
            this.outputBuffer = null;
        }
        this.decoder.flush();
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded && !this.audioTrack.hasPendingData();
    }

    @Override
    public boolean isReady() {
        return this.audioTrack.hasPendingData() || this.inputFormat != null && (this.isSourceReady() || this.outputBuffer != null);
    }

    @Override
    public long getPositionUs() {
        long newCurrentPositionUs = this.audioTrack.getCurrentPositionUs(this.isEnded());
        if (newCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? newCurrentPositionUs : Math.max(this.currentPositionUs, newCurrentPositionUs);
            this.allowPositionDiscontinuity = false;
        }
        return this.currentPositionUs;
    }

    protected void onAudioSessionId(int audioSessionId) {
    }

    @Override
    protected void onEnabled(boolean joining) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
        this.eventDispatcher.enabled(this.decoderCounters);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.audioTrack.reset();
        this.currentPositionUs = positionUs;
        this.allowPositionDiscontinuity = true;
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.decoder != null) {
            this.flushDecoder();
        }
    }

    @Override
    protected void onStarted() {
        this.audioTrack.play();
    }

    @Override
    protected void onStopped() {
        this.audioTrack.pause();
    }

    @Override
    protected void onDisabled() {
        this.inputBuffer = null;
        this.outputBuffer = null;
        this.inputFormat = null;
        this.audioSessionId = 0;
        try {
            if (this.decoder != null) {
                this.decoder.release();
                this.decoder = null;
                ++this.decoderCounters.decoderReleaseCount;
            }
            this.audioTrack.release();
        }
        finally {
            this.decoderCounters.ensureUpdated();
            this.eventDispatcher.disabled(this.decoderCounters);
        }
    }

    private boolean readFormat() {
        int result = this.readSource(this.formatHolder, null);
        if (result == -5) {
            this.onInputFormatChanged(this.formatHolder.format);
            return true;
        }
        return false;
    }

    private void onInputFormatChanged(Format newFormat) {
        this.inputFormat = newFormat;
        this.eventDispatcher.inputFormatChanged(newFormat);
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 2: {
                this.audioTrack.setVolume(((Float)message).floatValue());
                break;
            }
            case 3: {
                this.audioTrack.setPlaybackParams((PlaybackParams)message);
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }
}

