/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AudioTrack;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecRenderer;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecAudioRenderer
extends MediaCodecRenderer
implements MediaClock {
    private final AudioRendererEventListener.EventDispatcher eventDispatcher;
    private final AudioTrack audioTrack;
    private boolean passthroughEnabled;
    private MediaFormat passthroughMediaFormat;
    private int pcmEncoding;
    private int audioSessionId = 0;
    private long currentPositionUs;
    private boolean allowPositionDiscontinuity;
    private boolean audioTrackHasData;
    private long lastFeedElapsedRealtimeMs;

    public MediaCodecAudioRenderer(MediaCodecSelector mediaCodecSelector) {
        this(mediaCodecSelector, null, true);
    }

    public MediaCodecAudioRenderer(MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys) {
        this(mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, null, null);
    }

    public MediaCodecAudioRenderer(MediaCodecSelector mediaCodecSelector, Handler eventHandler, AudioRendererEventListener eventListener) {
        this(mediaCodecSelector, null, true, eventHandler, eventListener);
    }

    public MediaCodecAudioRenderer(MediaCodecSelector mediaCodecSelector, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, AudioRendererEventListener eventListener) {
        this(mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener, null, 3);
    }

    public MediaCodecAudioRenderer(MediaCodecSelector mediaCodecSelector, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, AudioRendererEventListener eventListener, AudioCapabilities audioCapabilities, int streamType) {
        super(1, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys);
        this.audioTrack = new AudioTrack(audioCapabilities, streamType);
        this.eventDispatcher = new AudioRendererEventListener.EventDispatcher(eventHandler, eventListener);
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        String mimeType = format.sampleMimeType;
        if (!MimeTypes.isAudio(mimeType)) {
            return 0;
        }
        if (this.allowPassthrough(mimeType) && mediaCodecSelector.getPassthroughDecoderInfo() != null) {
            return 7;
        }
        MediaCodecInfo decoderInfo = mediaCodecSelector.getDecoderInfo(mimeType, false);
        if (decoderInfo == null) {
            return 1;
        }
        boolean decoderCapable = Util.SDK_INT < 21 || (format.sampleRate == -1 || decoderInfo.isAudioSampleRateSupportedV21(format.sampleRate)) && (format.channelCount == -1 || decoderInfo.isAudioChannelCountSupportedV21(format.channelCount));
        int formatSupport = decoderCapable ? 3 : 2;
        return 4 | formatSupport;
    }

    @Override
    protected MediaCodecInfo getDecoderInfo(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo passthroughDecoderInfo;
        if (this.allowPassthrough(format.sampleMimeType) && (passthroughDecoderInfo = mediaCodecSelector.getPassthroughDecoderInfo()) != null) {
            this.passthroughEnabled = true;
            return passthroughDecoderInfo;
        }
        this.passthroughEnabled = false;
        return super.getDecoderInfo(mediaCodecSelector, format, requiresSecureDecoder);
    }

    protected boolean allowPassthrough(String mimeType) {
        return this.audioTrack.isPassthroughSupported(mimeType);
    }

    @Override
    protected void configureCodec(MediaCodec codec, Format format, MediaCrypto crypto) {
        if (this.passthroughEnabled) {
            this.passthroughMediaFormat = format.getFrameworkMediaFormatV16();
            this.passthroughMediaFormat.setString("mime", "audio/raw");
            codec.configure(this.passthroughMediaFormat, null, crypto, 0);
            this.passthroughMediaFormat.setString("mime", format.sampleMimeType);
        } else {
            codec.configure(format.getFrameworkMediaFormatV16(), null, crypto, 0);
            this.passthroughMediaFormat = null;
        }
    }

    @Override
    public MediaClock getMediaClock() {
        return this;
    }

    @Override
    protected void onCodecInitialized(String name, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
    }

    @Override
    protected void onInputFormatChanged(Format newFormat) throws ExoPlaybackException {
        super.onInputFormatChanged(newFormat);
        this.eventDispatcher.inputFormatChanged(newFormat);
        this.pcmEncoding = "audio/raw".equals(newFormat.sampleMimeType) ? newFormat.pcmEncoding : 2;
    }

    @Override
    protected void onOutputFormatChanged(MediaCodec codec, MediaFormat outputFormat) {
        boolean passthrough = this.passthroughMediaFormat != null;
        String mimeType = passthrough ? this.passthroughMediaFormat.getString("mime") : "audio/raw";
        MediaFormat format = passthrough ? this.passthroughMediaFormat : outputFormat;
        int channelCount = format.getInteger("channel-count");
        int sampleRate = format.getInteger("sample-rate");
        this.audioTrack.configure(mimeType, channelCount, sampleRate, this.pcmEncoding, 0);
    }

    protected void onAudioSessionId(int audioSessionId) {
    }

    @Override
    protected void onEnabled(boolean joining) throws ExoPlaybackException {
        super.onEnabled(joining);
        this.eventDispatcher.enabled(this.decoderCounters);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        super.onPositionReset(positionUs, joining);
        this.audioTrack.reset();
        this.currentPositionUs = positionUs;
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.audioTrack.play();
    }

    @Override
    protected void onStopped() {
        this.audioTrack.pause();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.audioSessionId = 0;
        try {
            this.audioTrack.release();
        }
        finally {
            try {
                super.onDisabled();
            }
            finally {
                this.decoderCounters.ensureUpdated();
                this.eventDispatcher.disabled(this.decoderCounters);
            }
        }
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && !this.audioTrack.hasPendingData();
    }

    @Override
    public boolean isReady() {
        return this.audioTrack.hasPendingData() || super.isReady();
    }

    @Override
    public long getPositionUs() {
        long newCurrentPositionUs = this.audioTrack.getCurrentPositionUs(this.isEnded());
        if (newCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? newCurrentPositionUs : Math.max(this.currentPositionUs, newCurrentPositionUs);
            this.allowPositionDiscontinuity = false;
        }
        return this.currentPositionUs;
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, int bufferIndex, int bufferFlags, long bufferPresentationTimeUs, boolean shouldSkip) throws ExoPlaybackException {
        int handleBufferResult;
        if (this.passthroughEnabled && (bufferFlags & 2) != 0) {
            codec.releaseOutputBuffer(bufferIndex, false);
            return true;
        }
        if (shouldSkip) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.decoderCounters.skippedOutputBufferCount;
            this.audioTrack.handleDiscontinuity();
            return true;
        }
        if (!this.audioTrack.isInitialized()) {
            try {
                if (this.audioSessionId == 0) {
                    this.audioSessionId = this.audioTrack.initialize(0);
                    this.eventDispatcher.audioSessionId(this.audioSessionId);
                    this.onAudioSessionId(this.audioSessionId);
                } else {
                    this.audioTrack.initialize(this.audioSessionId);
                }
                this.audioTrackHasData = false;
            }
            catch (AudioTrack.InitializationException e) {
                throw ExoPlaybackException.createForRenderer(e, this.getIndex());
            }
            if (this.getState() == 2) {
                this.audioTrack.play();
            }
        } else {
            boolean audioTrackHadData = this.audioTrackHasData;
            this.audioTrackHasData = this.audioTrack.hasPendingData();
            if (audioTrackHadData && !this.audioTrackHasData && this.getState() == 2) {
                long elapsedSinceLastFeedMs = SystemClock.elapsedRealtime() - this.lastFeedElapsedRealtimeMs;
                long bufferSizeMs = C.usToMs(this.audioTrack.getBufferSizeUs());
                this.eventDispatcher.audioTrackUnderrun(this.audioTrack.getBufferSize(), bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }
        try {
            handleBufferResult = this.audioTrack.handleBuffer(buffer, bufferPresentationTimeUs);
            this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        }
        catch (AudioTrack.WriteException e) {
            throw ExoPlaybackException.createForRenderer(e, this.getIndex());
        }
        if ((handleBufferResult & 1) != 0) {
            this.handleAudioTrackDiscontinuity();
            this.allowPositionDiscontinuity = true;
        }
        if ((handleBufferResult & 2) != 0) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.decoderCounters.renderedOutputBufferCount;
            return true;
        }
        return false;
    }

    @Override
    protected void onOutputStreamEnded() {
        this.audioTrack.handleEndOfStream();
    }

    protected void handleAudioTrackDiscontinuity() {
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 2: {
                this.audioTrack.setVolume(((Float)message).floatValue());
                break;
            }
            case 3: {
                this.audioTrack.setPlaybackParams((PlaybackParams)message);
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }
}

