/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.os.Handler;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.util.Assertions;

public interface AudioRendererEventListener {
    public void onAudioEnabled(DecoderCounters var1);

    public void onAudioSessionId(int var1);

    public void onAudioDecoderInitialized(String var1, long var2, long var4);

    public void onAudioInputFormatChanged(Format var1);

    public void onAudioTrackUnderrun(int var1, long var2, long var4);

    public void onAudioDisabled(DecoderCounters var1);

    public static final class EventDispatcher {
        private final Handler handler;
        private final AudioRendererEventListener listener;

        public EventDispatcher(Handler handler, AudioRendererEventListener listener) {
            this.handler = listener != null ? Assertions.checkNotNull(handler) : null;
            this.listener = listener;
        }

        public void enabled(final DecoderCounters decoderCounters) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onAudioEnabled(decoderCounters);
                    }
                });
            }
        }

        public void decoderInitialized(final String decoderName, final long initializedTimestampMs, final long initializationDurationMs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
                    }
                });
            }
        }

        public void inputFormatChanged(final Format format) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onAudioInputFormatChanged(format);
                    }
                });
            }
        }

        public void audioTrackUnderrun(final int bufferSize, final long bufferSizeMs, final long elapsedSinceLastFeedMs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onAudioTrackUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
                    }
                });
            }
        }

        public void disabled(final DecoderCounters counters) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        counters.ensureUpdated();
                        EventDispatcher.this.listener.onAudioDisabled(counters);
                    }
                });
            }
        }

        public void audioSessionId(final int audioSessionId) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onAudioSessionId(audioSessionId);
                    }
                });
            }
        }
    }
}

