/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import com.google.android.exoplayer2.C;

public abstract class Timeline {
    public abstract int getWindowCount();

    public final Window getWindow(int windowIndex, Window window) {
        return this.getWindow(windowIndex, window, false);
    }

    public abstract Window getWindow(int var1, Window var2, boolean var3);

    public abstract int getPeriodCount();

    public final Period getPeriod(int periodIndex, Period period) {
        return this.getPeriod(periodIndex, period, false);
    }

    public abstract Period getPeriod(int var1, Period var2, boolean var3);

    public abstract int getIndexOfPeriod(Object var1);

    public static final class Period {
        public Object id;
        public Object uid;
        public int windowIndex;
        private long durationUs;
        private long positionInWindowUs;

        public Period set(Object id2, Object uid, int windowIndex, long durationUs, long positionInWindowUs) {
            this.id = id2;
            this.uid = uid;
            this.windowIndex = windowIndex;
            this.durationUs = durationUs;
            this.positionInWindowUs = positionInWindowUs;
            return this;
        }

        public long getDurationMs() {
            return C.usToMs(this.durationUs);
        }

        public long getDurationUs() {
            return this.durationUs;
        }

        public long getPositionInWindowMs() {
            return C.usToMs(this.positionInWindowUs);
        }

        public long getPositionInWindowUs() {
            return this.positionInWindowUs;
        }
    }

    public static final class Window {
        public Object id;
        public long presentationStartTimeMs;
        public long windowStartTimeMs;
        public boolean isSeekable;
        public boolean isDynamic;
        public int firstPeriodIndex;
        public int lastPeriodIndex;
        private long defaultPositionUs;
        private long durationUs;
        private long positionInFirstPeriodUs;

        public Window set(Object id2, long presentationStartTimeMs, long windowStartTimeMs, boolean isSeekable, boolean isDynamic, long defaultPositionUs, long durationUs, int firstPeriodIndex, int lastPeriodIndex, long positionInFirstPeriodUs) {
            this.id = id2;
            this.presentationStartTimeMs = presentationStartTimeMs;
            this.windowStartTimeMs = windowStartTimeMs;
            this.isSeekable = isSeekable;
            this.isDynamic = isDynamic;
            this.defaultPositionUs = defaultPositionUs;
            this.durationUs = durationUs;
            this.firstPeriodIndex = firstPeriodIndex;
            this.lastPeriodIndex = lastPeriodIndex;
            this.positionInFirstPeriodUs = positionInFirstPeriodUs;
            return this;
        }

        public long getDefaultPositionMs() {
            return C.usToMs(this.defaultPositionUs);
        }

        public long getDefaultPositionUs() {
            return this.defaultPositionUs;
        }

        public long getDurationMs() {
            return C.usToMs(this.durationUs);
        }

        public long getDurationUs() {
            return this.durationUs;
        }

        public long getPositionInFirstPeriodMs() {
            return C.usToMs(this.positionInFirstPeriodUs);
        }

        public long getPositionInFirstPeriodUs() {
            return this.positionInFirstPeriodUs;
        }
    }
}

