/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImpl;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.MediaCodecAudioRenderer;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.trackselection.TrackSelections;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.video.MediaCodecVideoRenderer;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=16)
public final class SimpleExoPlayer
implements ExoPlayer {
    private static final String TAG = "SimpleExoPlayer";
    private static final int MAX_DROPPED_VIDEO_FRAME_COUNT_TO_NOTIFY = 50;
    private final ExoPlayer player;
    private final Renderer[] renderers;
    private final ComponentListener componentListener;
    private final Handler mainHandler = new Handler();
    private final int videoRendererCount;
    private final int audioRendererCount;
    private boolean videoTracksEnabled;
    private Format videoFormat;
    private Format audioFormat;
    private Surface surface;
    private boolean ownsSurface;
    private SurfaceHolder surfaceHolder;
    private TextureView textureView;
    private TextRenderer.Output textOutput;
    private MetadataRenderer.Output<List<Id3Frame>> id3Output;
    private VideoListener videoListener;
    private AudioRendererEventListener audioDebugListener;
    private VideoRendererEventListener videoDebugListener;
    private DecoderCounters videoDecoderCounters;
    private DecoderCounters audioDecoderCounters;
    private int audioSessionId;
    private float volume;
    private PlaybackParamsHolder playbackParamsHolder;

    SimpleExoPlayer(Context context, TrackSelector<?> trackSelector, LoadControl loadControl, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean preferExtensionDecoders, long allowedVideoJoiningTimeMs) {
        this.componentListener = new ComponentListener();
        trackSelector.addListener(this.componentListener);
        ArrayList<Renderer> renderersList = new ArrayList<Renderer>();
        if (preferExtensionDecoders) {
            this.buildExtensionRenderers(renderersList, allowedVideoJoiningTimeMs);
            this.buildRenderers(context, drmSessionManager, renderersList, allowedVideoJoiningTimeMs);
        } else {
            this.buildRenderers(context, drmSessionManager, renderersList, allowedVideoJoiningTimeMs);
            this.buildExtensionRenderers(renderersList, allowedVideoJoiningTimeMs);
        }
        this.renderers = renderersList.toArray(new Renderer[renderersList.size()]);
        int videoRendererCount = 0;
        int audioRendererCount = 0;
        block4: for (Renderer renderer : this.renderers) {
            switch (renderer.getTrackType()) {
                case 2: {
                    ++videoRendererCount;
                    continue block4;
                }
                case 1: {
                    ++audioRendererCount;
                }
            }
        }
        this.videoRendererCount = videoRendererCount;
        this.audioRendererCount = audioRendererCount;
        this.audioSessionId = 0;
        this.volume = 1.0f;
        this.player = new ExoPlayerImpl(this.renderers, trackSelector, loadControl);
    }

    public int getRendererCount() {
        return this.renderers.length;
    }

    public int getRendererType(int index) {
        return this.renderers[index].getTrackType();
    }

    public void clearVideoSurface() {
        this.setVideoSurface(null);
    }

    public void setVideoSurface(Surface surface) {
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(surface, false);
    }

    public void setVideoSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.removeSurfaceCallbacks();
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
        } else {
            this.setVideoSurfaceInternal(surfaceHolder.getSurface(), false);
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
        }
    }

    public void setVideoSurfaceView(SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView.getHolder());
    }

    public void setVideoTextureView(TextureView textureView) {
        this.removeSurfaceCallbacks();
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
        } else {
            SurfaceTexture surfaceTexture;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            this.setVideoSurfaceInternal((surfaceTexture = textureView.getSurfaceTexture()) == null ? null : new Surface(surfaceTexture), true);
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
        }
    }

    public void setVolume(float volume) {
        this.volume = volume;
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.audioRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage(renderer, 2, Float.valueOf(volume));
        }
        this.player.sendMessages(messages);
    }

    public float getVolume() {
        return this.volume;
    }

    @TargetApi(value=23)
    public void setPlaybackParams(PlaybackParams params) {
        if (params != null) {
            params.allowDefaults();
            this.playbackParamsHolder = new PlaybackParamsHolder(params);
        } else {
            this.playbackParamsHolder = null;
        }
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.audioRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 1) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage(renderer, 3, params);
        }
        this.player.sendMessages(messages);
    }

    @TargetApi(value=23)
    public PlaybackParams getPlaybackParams() {
        return this.playbackParamsHolder == null ? null : this.playbackParamsHolder.params;
    }

    public Format getVideoFormat() {
        return this.videoFormat;
    }

    public Format getAudioFormat() {
        return this.audioFormat;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    public void setVideoListener(VideoListener listener) {
        this.videoListener = listener;
    }

    public void setVideoDebugListener(VideoRendererEventListener listener) {
        this.videoDebugListener = listener;
    }

    public void setAudioDebugListener(AudioRendererEventListener listener) {
        this.audioDebugListener = listener;
    }

    public void setTextOutput(TextRenderer.Output output) {
        this.textOutput = output;
    }

    public void setId3Output(MetadataRenderer.Output<List<Id3Frame>> output) {
        this.id3Output = output;
    }

    @Override
    public void addListener(ExoPlayer.EventListener listener) {
        this.player.addListener(listener);
    }

    @Override
    public void removeListener(ExoPlayer.EventListener listener) {
        this.player.removeListener(listener);
    }

    @Override
    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    @Override
    public void prepare(MediaSource mediaSource) {
        this.player.prepare(mediaSource);
    }

    @Override
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetTimeline) {
        this.player.prepare(mediaSource, resetPosition, resetTimeline);
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    @Override
    public boolean isLoading() {
        return this.player.isLoading();
    }

    @Override
    public void seekToDefaultPosition() {
        this.player.seekToDefaultPosition();
    }

    @Override
    public void seekToDefaultPosition(int windowIndex) {
        this.player.seekToDefaultPosition(windowIndex);
    }

    @Override
    public void seekTo(long positionMs) {
        this.player.seekTo(positionMs);
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        this.player.seekTo(windowIndex, positionMs);
    }

    @Override
    public void stop() {
        this.player.stop();
    }

    @Override
    public void release() {
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
    }

    @Override
    public void sendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.player.sendMessages(messages);
    }

    @Override
    public void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.player.blockingSendMessages(messages);
    }

    @Override
    public int getCurrentPeriodIndex() {
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public long getDuration() {
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.player.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Override
    public Timeline getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    @Override
    public Object getCurrentManifest() {
        return this.player.getCurrentManifest();
    }

    private void buildRenderers(Context context, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, ArrayList<Renderer> renderersList, long allowedVideoJoiningTimeMs) {
        MediaCodecVideoRenderer videoRenderer = new MediaCodecVideoRenderer(context, MediaCodecSelector.DEFAULT, 1, allowedVideoJoiningTimeMs, drmSessionManager, false, this.mainHandler, this.componentListener, 50);
        renderersList.add(videoRenderer);
        MediaCodecAudioRenderer audioRenderer = new MediaCodecAudioRenderer(MediaCodecSelector.DEFAULT, drmSessionManager, true, this.mainHandler, this.componentListener, AudioCapabilities.getCapabilities(context), 3);
        renderersList.add(audioRenderer);
        TextRenderer textRenderer = new TextRenderer(this.componentListener, this.mainHandler.getLooper());
        renderersList.add(textRenderer);
        MetadataRenderer<List<Id3Frame>> id3Renderer = new MetadataRenderer<List<Id3Frame>>(this.componentListener, this.mainHandler.getLooper(), new Id3Decoder());
        renderersList.add(id3Renderer);
    }

    private void buildExtensionRenderers(ArrayList<Renderer> renderersList, long allowedVideoJoiningTimeMs) {
        Constructor<?> constructor;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("com.google.android.exoplayer2.ext.vp9.LibvpxVideoRenderer");
            constructor = clazz2.getConstructor(Boolean.TYPE, Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
            renderersList.add((Renderer)constructor.newInstance(true, allowedVideoJoiningTimeMs, this.mainHandler, this.componentListener, 50));
            Log.i((String)TAG, (String)"Loaded LibvpxVideoRenderer.");
        }
        catch (ClassNotFoundException clazz2) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            clazz2 = Class.forName("com.google.android.exoplayer2.ext.opus.LibopusAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class);
            renderersList.add((Renderer)constructor.newInstance(this.mainHandler, this.componentListener));
            Log.i((String)TAG, (String)"Loaded LibopusAudioRenderer.");
        }
        catch (ClassNotFoundException clazz3) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            clazz2 = Class.forName("com.google.android.exoplayer2.ext.flac.LibflacAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class);
            renderersList.add((Renderer)constructor.newInstance(this.mainHandler, this.componentListener));
            Log.i((String)TAG, (String)"Loaded LibflacAudioRenderer.");
        }
        catch (ClassNotFoundException clazz4) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            clazz2 = Class.forName("com.google.android.exoplayer2.ext.ffmpeg.FfmpegAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class);
            renderersList.add((Renderer)constructor.newInstance(this.mainHandler, this.componentListener));
            Log.i((String)TAG, (String)"Loaded FfmpegAudioRenderer.");
        }
        catch (ClassNotFoundException clazz5) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(Surface surface, boolean ownsSurface) {
        ExoPlayer.ExoPlayerMessage[] messages = new ExoPlayer.ExoPlayerMessage[this.videoRendererCount];
        int count = 0;
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages[count++] = new ExoPlayer.ExoPlayerMessage(renderer, 1, surface);
        }
        if (this.surface != null && this.surface != surface) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.player.blockingSendMessages(messages);
        } else {
            this.player.sendMessages(messages);
        }
        this.surface = surface;
        this.ownsSurface = ownsSurface;
    }

    @TargetApi(value=23)
    private static final class PlaybackParamsHolder {
        public final PlaybackParams params;

        public PlaybackParamsHolder(PlaybackParams params) {
            this.params = params;
        }
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextRenderer.Output,
    MetadataRenderer.Output<List<Id3Frame>>,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    TrackSelector.EventListener<Object> {
        private ComponentListener() {
        }

        @Override
        public void onVideoEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.videoDecoderCounters = counters;
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onVideoEnabled(counters);
            }
        }

        @Override
        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        @Override
        public void onVideoInputFormatChanged(Format format) {
            SimpleExoPlayer.this.videoFormat = format;
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onVideoInputFormatChanged(format);
            }
        }

        @Override
        public void onDroppedFrames(int count, long elapsed) {
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onDroppedFrames(count, elapsed);
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            if (SimpleExoPlayer.this.videoListener != null) {
                SimpleExoPlayer.this.videoListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
        }

        @Override
        public void onRenderedFirstFrame(Surface surface) {
            if (SimpleExoPlayer.this.videoListener != null && SimpleExoPlayer.this.surface == surface) {
                SimpleExoPlayer.this.videoListener.onRenderedFirstFrame();
            }
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onRenderedFirstFrame(surface);
            }
        }

        @Override
        public void onVideoDisabled(DecoderCounters counters) {
            if (SimpleExoPlayer.this.videoDebugListener != null) {
                SimpleExoPlayer.this.videoDebugListener.onVideoDisabled(counters);
            }
            SimpleExoPlayer.this.videoFormat = null;
            SimpleExoPlayer.this.videoDecoderCounters = null;
        }

        @Override
        public void onAudioEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.audioDecoderCounters = counters;
            if (SimpleExoPlayer.this.audioDebugListener != null) {
                SimpleExoPlayer.this.audioDebugListener.onAudioEnabled(counters);
            }
        }

        @Override
        public void onAudioSessionId(int sessionId) {
            SimpleExoPlayer.this.audioSessionId = sessionId;
            if (SimpleExoPlayer.this.audioDebugListener != null) {
                SimpleExoPlayer.this.audioDebugListener.onAudioSessionId(sessionId);
            }
        }

        @Override
        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (SimpleExoPlayer.this.audioDebugListener != null) {
                SimpleExoPlayer.this.audioDebugListener.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        @Override
        public void onAudioInputFormatChanged(Format format) {
            SimpleExoPlayer.this.audioFormat = format;
            if (SimpleExoPlayer.this.audioDebugListener != null) {
                SimpleExoPlayer.this.audioDebugListener.onAudioInputFormatChanged(format);
            }
        }

        @Override
        public void onAudioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            if (SimpleExoPlayer.this.audioDebugListener != null) {
                SimpleExoPlayer.this.audioDebugListener.onAudioTrackUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }

        @Override
        public void onAudioDisabled(DecoderCounters counters) {
            if (SimpleExoPlayer.this.audioDebugListener != null) {
                SimpleExoPlayer.this.audioDebugListener.onAudioDisabled(counters);
            }
            SimpleExoPlayer.this.audioFormat = null;
            SimpleExoPlayer.this.audioDecoderCounters = null;
            SimpleExoPlayer.this.audioSessionId = 0;
        }

        @Override
        public void onCues(List<Cue> cues) {
            if (SimpleExoPlayer.this.textOutput != null) {
                SimpleExoPlayer.this.textOutput.onCues(cues);
            }
        }

        @Override
        public void onMetadata(List<Id3Frame> id3Frames) {
            if (SimpleExoPlayer.this.id3Output != null) {
                SimpleExoPlayer.this.id3Output.onMetadata(id3Frames);
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(holder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, false);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, true);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void onTrackSelectionsChanged(TrackSelections<?> trackSelections) {
            boolean videoTracksEnabled = false;
            for (int i = 0; i < SimpleExoPlayer.this.renderers.length; ++i) {
                if (SimpleExoPlayer.this.renderers[i].getTrackType() != 2 || trackSelections.get(i) == null) continue;
                videoTracksEnabled = true;
                break;
            }
            if (SimpleExoPlayer.this.videoListener != null && SimpleExoPlayer.this.videoTracksEnabled && !videoTracksEnabled) {
                SimpleExoPlayer.this.videoListener.onVideoTracksDisabled();
            }
            SimpleExoPlayer.this.videoTracksEnabled = videoTracksEnabled;
        }
    }

    public static interface VideoListener {
        public void onVideoSizeChanged(int var1, int var2, int var3, float var4);

        public void onRenderedFirstFrame();

        public void onVideoTracksDisabled();
    }
}

