/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelections;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.PriorityHandlerThread;
import com.google.android.exoplayer2.util.StandaloneMediaClock;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class ExoPlayerImplInternal<T>
implements Handler.Callback,
MediaPeriod.Callback,
TrackSelector.InvalidationListener,
MediaSource.Listener {
    private static final String TAG = "ExoPlayerImplInternal";
    public static final int MSG_STATE_CHANGED = 1;
    public static final int MSG_LOADING_CHANGED = 2;
    public static final int MSG_SEEK_ACK = 3;
    public static final int MSG_POSITION_DISCONTINUITY = 4;
    public static final int MSG_SOURCE_INFO_REFRESHED = 5;
    public static final int MSG_ERROR = 6;
    private static final int MSG_PREPARE = 0;
    private static final int MSG_SET_PLAY_WHEN_READY = 1;
    private static final int MSG_DO_SOME_WORK = 2;
    private static final int MSG_SEEK_TO = 3;
    private static final int MSG_STOP = 4;
    private static final int MSG_RELEASE = 5;
    private static final int MSG_REFRESH_SOURCE_INFO = 6;
    private static final int MSG_PERIOD_PREPARED = 7;
    private static final int MSG_SOURCE_CONTINUE_LOADING_REQUESTED = 8;
    private static final int MSG_TRACK_SELECTION_INVALIDATED = 9;
    private static final int MSG_CUSTOM = 10;
    private static final int PREPARING_SOURCE_INTERVAL_MS = 10;
    private static final int RENDERING_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private static final int MAXIMUM_BUFFER_AHEAD_PERIODS = 100;
    private final Renderer[] renderers;
    private final RendererCapabilities[] rendererCapabilities;
    private final TrackSelector<T> trackSelector;
    private final LoadControl loadControl;
    private final StandaloneMediaClock standaloneMediaClock;
    private final Handler handler;
    private final HandlerThread internalPlaybackThread;
    private final Handler eventHandler;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private PlaybackInfo playbackInfo;
    private Renderer rendererMediaClockSource;
    private MediaClock rendererMediaClock;
    private MediaSource mediaSource;
    private Renderer[] enabledRenderers;
    private boolean released;
    private boolean playWhenReady;
    private boolean rebuffering;
    private boolean isLoading;
    private int state;
    private int customMessagesSent;
    private int customMessagesProcessed;
    private long elapsedRealtimeUs;
    private long rendererPositionUs;
    private boolean isTimelineReady;
    private boolean isTimelineEnded;
    private int bufferAheadPeriodCount;
    private MediaPeriodHolder<T> playingPeriodHolder;
    private MediaPeriodHolder<T> readingPeriodHolder;
    private MediaPeriodHolder<T> loadingPeriodHolder;
    private Timeline timeline;

    public ExoPlayerImplInternal(Renderer[] renderers, TrackSelector<T> trackSelector, LoadControl loadControl, boolean playWhenReady, Handler eventHandler, PlaybackInfo playbackInfo) {
        this.renderers = renderers;
        this.trackSelector = trackSelector;
        this.loadControl = loadControl;
        this.playWhenReady = playWhenReady;
        this.eventHandler = eventHandler;
        this.state = 1;
        this.playbackInfo = playbackInfo;
        this.rendererCapabilities = new RendererCapabilities[renderers.length];
        for (int i = 0; i < renderers.length; ++i) {
            renderers[i].setIndex(i);
            this.rendererCapabilities[i] = renderers[i].getCapabilities();
        }
        this.standaloneMediaClock = new StandaloneMediaClock();
        this.enabledRenderers = new Renderer[0];
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        trackSelector.init(this);
        this.internalPlaybackThread = new PriorityHandlerThread("ExoPlayerImplInternal:Handler", -16);
        this.internalPlaybackThread.start();
        this.handler = new Handler(this.internalPlaybackThread.getLooper(), (Handler.Callback)this);
    }

    public void prepare(MediaSource mediaSource, boolean resetPosition) {
        this.handler.obtainMessage(0, resetPosition ? 1 : 0, 0, (Object)mediaSource).sendToTarget();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.handler.obtainMessage(1, playWhenReady ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(int periodIndex, long positionUs) {
        this.handler.obtainMessage(3, periodIndex, 0, (Object)positionUs).sendToTarget();
    }

    public void stop() {
        this.handler.sendEmptyMessage(4);
    }

    public void sendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        if (this.released) {
            Log.w((String)TAG, (String)"Ignoring messages sent after release.");
            return;
        }
        ++this.customMessagesSent;
        this.handler.obtainMessage(10, (Object)messages).sendToTarget();
    }

    public synchronized void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        if (this.released) {
            Log.w((String)TAG, (String)"Ignoring messages sent after release.");
            return;
        }
        int messageNumber = this.customMessagesSent++;
        this.handler.obtainMessage(10, (Object)messages).sendToTarget();
        while (this.customMessagesProcessed <= messageNumber) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void release() {
        if (this.released) {
            return;
        }
        this.handler.sendEmptyMessage(5);
        while (!this.released) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.internalPlaybackThread.quit();
    }

    @Override
    public void onSourceInfoRefreshed(Timeline timeline, Object manifest) {
        this.handler.obtainMessage(6, (Object)Pair.create((Object)timeline, (Object)manifest)).sendToTarget();
    }

    @Override
    public void onPrepared(MediaPeriod source) {
        this.handler.obtainMessage(7, (Object)source).sendToTarget();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        this.handler.obtainMessage(8, (Object)source).sendToTarget();
    }

    @Override
    public void onTrackSelectionsInvalidated() {
        this.handler.sendEmptyMessage(9);
    }

    public boolean handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 0: {
                    this.prepareInternal((MediaSource)msg.obj, msg.arg1 != 0);
                    return true;
                }
                case 1: {
                    this.setPlayWhenReadyInternal(msg.arg1 != 0);
                    return true;
                }
                case 2: {
                    this.doSomeWork();
                    return true;
                }
                case 3: {
                    this.seekToInternal(msg.arg1, (Long)msg.obj);
                    return true;
                }
                case 4: {
                    this.stopInternal();
                    return true;
                }
                case 5: {
                    this.releaseInternal();
                    return true;
                }
                case 7: {
                    this.handlePeriodPrepared((MediaPeriod)msg.obj);
                    return true;
                }
                case 6: {
                    this.handleSourceInfoRefreshed((Pair<Timeline, Object>)((Pair)msg.obj));
                    return true;
                }
                case 8: {
                    this.handleContinueLoadingRequested((MediaPeriod)msg.obj);
                    return true;
                }
                case 9: {
                    this.reselectTracksInternal();
                    return true;
                }
                case 10: {
                    this.sendMessagesInternal((ExoPlayer.ExoPlayerMessage[])msg.obj);
                    return true;
                }
            }
            return false;
        }
        catch (ExoPlaybackException e) {
            Log.e((String)TAG, (String)"Renderer error.", (Throwable)e);
            this.eventHandler.obtainMessage(6, (Object)e).sendToTarget();
            this.stopInternal();
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Source error.", (Throwable)e);
            this.eventHandler.obtainMessage(6, (Object)ExoPlaybackException.createForSource(e)).sendToTarget();
            this.stopInternal();
            return true;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Internal runtime error.", (Throwable)e);
            this.eventHandler.obtainMessage(6, (Object)ExoPlaybackException.createForUnexpected(e)).sendToTarget();
            this.stopInternal();
            return true;
        }
    }

    private void setState(int state) {
        if (this.state != state) {
            this.state = state;
            this.eventHandler.obtainMessage(1, state, 0).sendToTarget();
        }
    }

    private void setIsLoading(boolean isLoading) {
        if (this.isLoading != isLoading) {
            this.isLoading = isLoading;
            this.eventHandler.obtainMessage(2, isLoading ? 1 : 0, 0).sendToTarget();
        }
    }

    private void prepareInternal(MediaSource mediaSource, boolean resetPosition) throws ExoPlaybackException {
        this.resetInternal();
        this.loadControl.onPrepared();
        if (resetPosition) {
            this.playbackInfo = new PlaybackInfo(0, -9223372036854775807L);
        }
        this.mediaSource = mediaSource;
        mediaSource.prepareSource(this);
        this.setState(2);
        this.handler.sendEmptyMessage(2);
    }

    private void setPlayWhenReadyInternal(boolean playWhenReady) throws ExoPlaybackException {
        this.rebuffering = false;
        this.playWhenReady = playWhenReady;
        if (!playWhenReady) {
            this.stopRenderers();
            this.updatePlaybackPositions();
        } else if (this.state == 3) {
            this.startRenderers();
            this.handler.sendEmptyMessage(2);
        } else if (this.state == 2) {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        this.rebuffering = false;
        this.standaloneMediaClock.start();
        for (Renderer renderer : this.enabledRenderers) {
            renderer.start();
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.standaloneMediaClock.stop();
        for (Renderer renderer : this.enabledRenderers) {
            this.ensureStopped(renderer);
        }
    }

    private void updatePlaybackPositions() throws ExoPlaybackException {
        if (this.playingPeriodHolder == null) {
            return;
        }
        long periodPositionUs = this.playingPeriodHolder.mediaPeriod.readDiscontinuity();
        if (periodPositionUs != -9223372036854775807L) {
            this.resetRendererPosition(periodPositionUs);
        } else {
            if (this.rendererMediaClockSource != null && !this.rendererMediaClockSource.isEnded()) {
                this.rendererPositionUs = this.rendererMediaClock.getPositionUs();
                this.standaloneMediaClock.setPositionUs(this.rendererPositionUs);
            } else {
                this.rendererPositionUs = this.standaloneMediaClock.getPositionUs();
            }
            periodPositionUs = this.rendererPositionUs - this.playingPeriodHolder.rendererPositionOffsetUs;
        }
        this.playbackInfo.positionUs = periodPositionUs;
        this.elapsedRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
        long bufferedPositionUs = this.enabledRenderers.length == 0 ? Long.MIN_VALUE : this.playingPeriodHolder.mediaPeriod.getBufferedPositionUs();
        this.playbackInfo.bufferedPositionUs = bufferedPositionUs == Long.MIN_VALUE ? this.timeline.getPeriod(this.playingPeriodHolder.index, this.period).getDurationUs() : bufferedPositionUs;
    }

    private void doSomeWork() throws ExoPlaybackException, IOException {
        long operationStartTimeMs = SystemClock.elapsedRealtime();
        this.updatePeriods();
        if (this.playingPeriodHolder == null) {
            this.maybeThrowPeriodPrepareError();
            this.scheduleNextWork(operationStartTimeMs, 10L);
            return;
        }
        TraceUtil.beginSection("doSomeWork");
        this.updatePlaybackPositions();
        boolean allRenderersEnded = true;
        boolean allRenderersReadyOrEnded = true;
        for (Renderer renderer : this.enabledRenderers) {
            boolean rendererReadyOrEnded;
            renderer.render(this.rendererPositionUs, this.elapsedRealtimeUs);
            allRenderersEnded = allRenderersEnded && renderer.isEnded();
            boolean bl = rendererReadyOrEnded = renderer.isReady() || renderer.isEnded();
            if (!rendererReadyOrEnded) {
                renderer.maybeThrowStreamError();
            }
            allRenderersReadyOrEnded = allRenderersReadyOrEnded && rendererReadyOrEnded;
        }
        if (!allRenderersReadyOrEnded) {
            this.maybeThrowPeriodPrepareError();
        }
        long playingPeriodDurationUs = this.timeline.getPeriod(this.playingPeriodHolder.index, this.period).getDurationUs();
        if (allRenderersEnded && (playingPeriodDurationUs == -9223372036854775807L || playingPeriodDurationUs <= this.playbackInfo.positionUs) && this.isTimelineEnded) {
            this.setState(4);
            this.stopRenderers();
        } else if (this.state == 2) {
            if (this.enabledRenderers.length > 0 ? allRenderersReadyOrEnded && this.haveSufficientBuffer(this.rebuffering) : this.isTimelineReady) {
                this.setState(3);
                if (this.playWhenReady) {
                    this.startRenderers();
                }
            }
        } else if (this.state == 3 && (this.enabledRenderers.length > 0 ? !allRenderersReadyOrEnded : !this.isTimelineReady)) {
            this.rebuffering = this.playWhenReady;
            this.setState(2);
            this.stopRenderers();
        }
        if (this.state == 2) {
            for (Renderer renderer : this.enabledRenderers) {
                renderer.maybeThrowStreamError();
            }
        }
        if (this.playWhenReady && this.state == 3 || this.state == 2) {
            this.scheduleNextWork(operationStartTimeMs, 10L);
        } else if (this.enabledRenderers.length != 0) {
            this.scheduleNextWork(operationStartTimeMs, 1000L);
        } else {
            this.handler.removeMessages(2);
        }
        TraceUtil.endSection();
    }

    private void scheduleNextWork(long thisOperationStartTimeMs, long intervalMs) {
        this.handler.removeMessages(2);
        long nextOperationStartTimeMs = thisOperationStartTimeMs + intervalMs;
        long nextOperationDelayMs = nextOperationStartTimeMs - SystemClock.elapsedRealtime();
        if (nextOperationDelayMs <= 0L) {
            this.handler.sendEmptyMessage(2);
        } else {
            this.handler.sendEmptyMessageDelayed(2, nextOperationDelayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToInternal(int periodIndex, long periodPositionUs) throws ExoPlaybackException {
        try {
            if (periodPositionUs == -9223372036854775807L && this.timeline != null && periodIndex < this.timeline.getPeriodCount()) {
                Pair<Integer, Long> defaultPosition = this.getDefaultPosition(periodIndex);
                periodIndex = (Integer)defaultPosition.first;
                periodPositionUs = (Long)defaultPosition.second;
            }
            if (periodIndex == this.playbackInfo.periodIndex && (periodPositionUs == -9223372036854775807L && this.playbackInfo.positionUs == -9223372036854775807L || periodPositionUs / 1000L == this.playbackInfo.positionUs / 1000L)) {
                return;
            }
            periodPositionUs = this.seekToPeriodPosition(periodIndex, periodPositionUs);
        }
        finally {
            this.playbackInfo = new PlaybackInfo(periodIndex, periodPositionUs);
            this.eventHandler.obtainMessage(3, (Object)this.playbackInfo).sendToTarget();
        }
    }

    private long seekToPeriodPosition(int periodIndex, long periodPositionUs) throws ExoPlaybackException {
        if (this.mediaSource == null) {
            if (periodPositionUs != -9223372036854775807L) {
                this.resetRendererPosition(periodPositionUs);
            }
            return periodPositionUs;
        }
        this.stopRenderers();
        this.rebuffering = false;
        this.setState(2);
        if (periodPositionUs == -9223372036854775807L || this.readingPeriodHolder != this.playingPeriodHolder && (periodIndex == this.playingPeriodHolder.index || periodIndex == this.readingPeriodHolder.index)) {
            periodIndex = -1;
        }
        MediaPeriodHolder<T> newPlayingPeriodHolder = null;
        if (this.playingPeriodHolder == null) {
            if (this.loadingPeriodHolder != null) {
                this.loadingPeriodHolder.release();
            }
        } else {
            MediaPeriodHolder<T> periodHolder = this.playingPeriodHolder;
            while (periodHolder != null) {
                if (periodHolder.index == periodIndex && periodHolder.prepared) {
                    newPlayingPeriodHolder = periodHolder;
                } else {
                    periodHolder.release();
                }
                periodHolder = periodHolder.next;
            }
        }
        if (newPlayingPeriodHolder != this.playingPeriodHolder) {
            for (Renderer renderer : this.enabledRenderers) {
                renderer.disable();
            }
            this.enabledRenderers = new Renderer[0];
            this.rendererMediaClock = null;
            this.rendererMediaClockSource = null;
        }
        this.bufferAheadPeriodCount = 0;
        if (newPlayingPeriodHolder != null) {
            newPlayingPeriodHolder.next = null;
            this.setPlayingPeriodHolder(newPlayingPeriodHolder);
            this.updateTimelineState();
            this.readingPeriodHolder = this.playingPeriodHolder;
            this.loadingPeriodHolder = this.playingPeriodHolder;
            if (this.playingPeriodHolder.hasEnabledTracks) {
                periodPositionUs = this.playingPeriodHolder.mediaPeriod.seekToUs(periodPositionUs);
            }
            this.resetRendererPosition(periodPositionUs);
            this.maybeContinueLoading();
        } else {
            this.playingPeriodHolder = null;
            this.readingPeriodHolder = null;
            this.loadingPeriodHolder = null;
            if (periodPositionUs != -9223372036854775807L) {
                this.resetRendererPosition(periodPositionUs);
            }
        }
        this.updatePlaybackPositions();
        this.handler.sendEmptyMessage(2);
        return periodPositionUs;
    }

    private void resetRendererPosition(long periodPositionUs) throws ExoPlaybackException {
        long periodOffsetUs = this.playingPeriodHolder == null ? 0L : this.playingPeriodHolder.rendererPositionOffsetUs;
        this.rendererPositionUs = periodOffsetUs + periodPositionUs;
        this.standaloneMediaClock.setPositionUs(this.rendererPositionUs);
        for (Renderer renderer : this.enabledRenderers) {
            renderer.resetPosition(this.rendererPositionUs);
        }
    }

    private void stopInternal() {
        this.resetInternal();
        this.loadControl.onStopped();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        this.resetInternal();
        this.loadControl.onReleased();
        this.setState(1);
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal() {
        this.handler.removeMessages(2);
        this.rebuffering = false;
        this.standaloneMediaClock.stop();
        this.rendererMediaClock = null;
        this.rendererMediaClockSource = null;
        for (Renderer renderer : this.enabledRenderers) {
            try {
                this.ensureStopped(renderer);
                renderer.disable();
            }
            catch (ExoPlaybackException | RuntimeException e) {
                Log.e((String)TAG, (String)"Stop failed.", (Throwable)e);
            }
        }
        this.enabledRenderers = new Renderer[0];
        this.releasePeriodHoldersFrom(this.playingPeriodHolder != null ? this.playingPeriodHolder : this.loadingPeriodHolder);
        if (this.mediaSource != null) {
            this.mediaSource.releaseSource();
            this.mediaSource = null;
        }
        this.isTimelineReady = false;
        this.isTimelineEnded = false;
        this.playingPeriodHolder = null;
        this.readingPeriodHolder = null;
        this.loadingPeriodHolder = null;
        this.timeline = null;
        this.bufferAheadPeriodCount = 0;
        this.setIsLoading(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessagesInternal(ExoPlayer.ExoPlayerMessage[] messages) throws ExoPlaybackException {
        try {
            for (ExoPlayer.ExoPlayerMessage message : messages) {
                message.target.handleMessage(message.messageType, message.message);
            }
            if (this.mediaSource != null) {
                this.handler.sendEmptyMessage(2);
            }
        }
        finally {
            ExoPlayerImplInternal exoPlayerImplInternal = this;
            synchronized (exoPlayerImplInternal) {
                ++this.customMessagesProcessed;
                this.notifyAll();
            }
        }
    }

    private void ensureStopped(Renderer renderer) throws ExoPlaybackException {
        if (renderer.getState() == 2) {
            renderer.stop();
        }
    }

    private void reselectTracksInternal() throws ExoPlaybackException {
        if (this.playingPeriodHolder == null) {
            return;
        }
        MediaPeriodHolder<T> periodHolder = this.playingPeriodHolder;
        boolean selectionsChangedForReadPeriod = true;
        while (true) {
            if (periodHolder == null || !periodHolder.prepared) {
                return;
            }
            if (periodHolder.selectTracks()) break;
            if (periodHolder == this.readingPeriodHolder) {
                selectionsChangedForReadPeriod = false;
            }
            periodHolder = periodHolder.next;
        }
        if (selectionsChangedForReadPeriod) {
            boolean recreateStreams = this.readingPeriodHolder != this.playingPeriodHolder;
            this.releasePeriodHoldersFrom(this.playingPeriodHolder.next);
            this.playingPeriodHolder.next = null;
            this.readingPeriodHolder = this.playingPeriodHolder;
            this.loadingPeriodHolder = this.playingPeriodHolder;
            this.bufferAheadPeriodCount = 0;
            boolean[] streamResetFlags = new boolean[this.renderers.length];
            long periodPositionUs = this.playingPeriodHolder.updatePeriodTrackSelection(this.playbackInfo.positionUs, this.loadControl, recreateStreams, streamResetFlags);
            if (periodPositionUs != this.playbackInfo.positionUs) {
                this.playbackInfo.positionUs = periodPositionUs;
                this.resetRendererPosition(periodPositionUs);
            }
            int enabledRendererCount = 0;
            boolean[] rendererWasEnabledFlags = new boolean[this.renderers.length];
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                rendererWasEnabledFlags[i] = renderer.getState() != 0;
                SampleStream sampleStream = this.playingPeriodHolder.sampleStreams[i];
                if (sampleStream != null) {
                    ++enabledRendererCount;
                }
                if (!rendererWasEnabledFlags[i]) continue;
                if (sampleStream != renderer.getStream()) {
                    if (renderer == this.rendererMediaClockSource) {
                        if (sampleStream == null) {
                            this.standaloneMediaClock.setPositionUs(this.rendererMediaClock.getPositionUs());
                        }
                        this.rendererMediaClock = null;
                        this.rendererMediaClockSource = null;
                    }
                    this.ensureStopped(renderer);
                    renderer.disable();
                    continue;
                }
                if (!streamResetFlags[i]) continue;
                renderer.resetPosition(this.playbackInfo.positionUs);
            }
            this.trackSelector.onSelectionActivated(((MediaPeriodHolder)this.playingPeriodHolder).trackSelections);
            this.enableRenderers(rendererWasEnabledFlags, enabledRendererCount);
        } else {
            this.loadingPeriodHolder = periodHolder;
            periodHolder = this.loadingPeriodHolder.next;
            while (periodHolder != null) {
                periodHolder.release();
                periodHolder = periodHolder.next;
                --this.bufferAheadPeriodCount;
            }
            this.loadingPeriodHolder.next = null;
            long loadingPeriodPositionUs = Math.max(0L, this.rendererPositionUs - this.loadingPeriodHolder.rendererPositionOffsetUs);
            this.loadingPeriodHolder.updatePeriodTrackSelection(loadingPeriodPositionUs, this.loadControl, false);
        }
        this.maybeContinueLoading();
        this.updatePlaybackPositions();
        this.handler.sendEmptyMessage(2);
    }

    private boolean haveSufficientBuffer(boolean rebuffering) {
        long loadingPeriodBufferedPositionUs;
        if (this.loadingPeriodHolder == null) {
            return false;
        }
        long loadingPeriodPositionUs = this.rendererPositionUs - this.loadingPeriodHolder.rendererPositionOffsetUs;
        long l = loadingPeriodBufferedPositionUs = !this.loadingPeriodHolder.prepared ? 0L : this.loadingPeriodHolder.mediaPeriod.getBufferedPositionUs();
        if (loadingPeriodBufferedPositionUs == Long.MIN_VALUE) {
            if (this.loadingPeriodHolder.isLast) {
                return true;
            }
            loadingPeriodBufferedPositionUs = this.timeline.getPeriod(this.loadingPeriodHolder.index, this.period).getDurationUs();
        }
        return this.loadControl.shouldStartPlayback(loadingPeriodBufferedPositionUs - loadingPeriodPositionUs, rebuffering);
    }

    private void maybeThrowPeriodPrepareError() throws IOException {
        if (!(this.loadingPeriodHolder == null || this.loadingPeriodHolder.prepared || this.readingPeriodHolder != null && this.readingPeriodHolder.next != this.loadingPeriodHolder)) {
            for (Renderer renderer : this.enabledRenderers) {
                if (renderer.hasReadStreamToEnd()) continue;
                return;
            }
            this.loadingPeriodHolder.mediaPeriod.maybeThrowPrepareError();
        }
    }

    private void handleSourceInfoRefreshed(Pair<Timeline, Object> timelineAndManifest) throws ExoPlaybackException, IOException {
        this.eventHandler.obtainMessage(5, timelineAndManifest).sendToTarget();
        Timeline oldTimeline = this.timeline;
        this.timeline = (Timeline)timelineAndManifest.first;
        if (this.playingPeriodHolder != null) {
            int index = this.timeline.getIndexOfPeriod(this.playingPeriodHolder.uid);
            if (index == -1) {
                this.attemptRestart(this.timeline, oldTimeline, this.playingPeriodHolder.index);
                return;
            }
            this.timeline.getPeriod(index, this.period, true);
            this.playingPeriodHolder.setIndex(this.timeline, this.timeline.getWindow(this.period.windowIndex, this.window), index);
            MediaPeriodHolder<T> previousPeriodHolder = this.playingPeriodHolder;
            boolean seenReadingPeriod = false;
            this.bufferAheadPeriodCount = 0;
            while (previousPeriodHolder.next != null) {
                MediaPeriodHolder periodHolder = previousPeriodHolder.next;
                this.timeline.getPeriod(++index, this.period, true);
                if (!periodHolder.uid.equals(this.period.uid)) {
                    if (!seenReadingPeriod) {
                        index = this.playingPeriodHolder.index;
                        this.releasePeriodHoldersFrom(this.playingPeriodHolder);
                        this.playingPeriodHolder = null;
                        this.readingPeriodHolder = null;
                        this.loadingPeriodHolder = null;
                        long newPositionUs = this.seekToPeriodPosition(index, this.playbackInfo.positionUs);
                        if (newPositionUs != this.playbackInfo.positionUs) {
                            this.playbackInfo = new PlaybackInfo(index, newPositionUs);
                            this.eventHandler.obtainMessage(4, (Object)this.playbackInfo).sendToTarget();
                        }
                        return;
                    }
                    this.loadingPeriodHolder = previousPeriodHolder;
                    this.loadingPeriodHolder.next = null;
                    this.releasePeriodHoldersFrom(periodHolder);
                    break;
                }
                ++this.bufferAheadPeriodCount;
                int windowIndex = this.timeline.getPeriod((int)index, (Timeline.Period)this.period).windowIndex;
                periodHolder.setIndex(this.timeline, this.timeline.getWindow(windowIndex, this.window), index);
                if (periodHolder == this.readingPeriodHolder) {
                    seenReadingPeriod = true;
                }
                previousPeriodHolder = periodHolder;
            }
        } else if (this.loadingPeriodHolder != null) {
            Object uid = this.loadingPeriodHolder.uid;
            int index = this.timeline.getIndexOfPeriod(uid);
            if (index == -1) {
                this.attemptRestart(this.timeline, oldTimeline, this.loadingPeriodHolder.index);
                return;
            }
            int windowIndex = this.timeline.getPeriod((int)index, (Timeline.Period)this.period).windowIndex;
            this.loadingPeriodHolder.setIndex(this.timeline, this.timeline.getWindow(windowIndex, this.window), index);
        }
        if (oldTimeline != null) {
            int newPlayingIndex;
            int n = this.playingPeriodHolder != null ? this.playingPeriodHolder.index : (newPlayingIndex = this.loadingPeriodHolder != null ? this.loadingPeriodHolder.index : -1);
            if (newPlayingIndex != -1 && newPlayingIndex != this.playbackInfo.periodIndex) {
                this.playbackInfo = new PlaybackInfo(newPlayingIndex, this.playbackInfo.positionUs);
                this.updatePlaybackPositions();
                this.eventHandler.obtainMessage(4, (Object)this.playbackInfo).sendToTarget();
            }
        }
    }

    private void attemptRestart(Timeline newTimeline, Timeline oldTimeline, int oldPeriodIndex) throws ExoPlaybackException {
        int newPeriodIndex = -1;
        while (newPeriodIndex == -1 && oldPeriodIndex < oldTimeline.getPeriodCount() - 1) {
            newPeriodIndex = newTimeline.getIndexOfPeriod(oldTimeline.getPeriod((int)(++oldPeriodIndex), (Timeline.Period)this.period, (boolean)true).uid);
        }
        if (newPeriodIndex == -1) {
            this.stopInternal();
            return;
        }
        this.releasePeriodHoldersFrom(this.playingPeriodHolder != null ? this.playingPeriodHolder : this.loadingPeriodHolder);
        this.bufferAheadPeriodCount = 0;
        this.playingPeriodHolder = null;
        this.readingPeriodHolder = null;
        this.loadingPeriodHolder = null;
        Pair<Integer, Long> defaultPosition = this.getDefaultPosition(newPeriodIndex);
        newPeriodIndex = (Integer)defaultPosition.first;
        long newPlayingPositionUs = (Long)defaultPosition.second;
        this.playbackInfo = new PlaybackInfo(newPeriodIndex, newPlayingPositionUs);
        this.eventHandler.obtainMessage(4, (Object)this.playbackInfo).sendToTarget();
    }

    private Pair<Integer, Long> getDefaultPosition(int periodIndex) {
        long periodPositionUs;
        this.timeline.getPeriod(periodIndex, this.period);
        this.timeline.getWindow(this.period.windowIndex, this.window);
        periodIndex = this.window.firstPeriodIndex;
        this.timeline.getPeriod(periodIndex, this.period);
        for (periodPositionUs = this.window.getPositionInFirstPeriodUs() + this.window.getDefaultPositionUs(); periodIndex < this.window.lastPeriodIndex && periodPositionUs > this.period.getDurationMs(); periodPositionUs -= this.period.getDurationUs()) {
            this.timeline.getPeriod(periodIndex++, this.period);
        }
        return Pair.create((Object)periodIndex, (Object)periodPositionUs);
    }

    private void updatePeriods() throws ExoPlaybackException, IOException {
        if (this.timeline == null) {
            this.mediaSource.maybeThrowSourceInfoRefreshError();
            return;
        }
        if (this.loadingPeriodHolder == null || this.loadingPeriodHolder.isFullyBuffered() && !this.loadingPeriodHolder.isLast && this.bufferAheadPeriodCount < 100) {
            int newLoadingPeriodIndex;
            int n = newLoadingPeriodIndex = this.loadingPeriodHolder == null ? this.playbackInfo.periodIndex : this.loadingPeriodHolder.index + 1;
            if (newLoadingPeriodIndex >= this.timeline.getPeriodCount()) {
                this.mediaSource.maybeThrowSourceInfoRefreshError();
            } else {
                long periodStartPositionUs;
                int isFirstPeriodInWindow;
                int windowIndex = this.timeline.getPeriod((int)newLoadingPeriodIndex, (Timeline.Period)this.period).windowIndex;
                int n2 = isFirstPeriodInWindow = newLoadingPeriodIndex == this.timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).firstPeriodIndex ? 1 : 0;
                long l = this.loadingPeriodHolder == null ? this.playbackInfo.positionUs : (periodStartPositionUs = isFirstPeriodInWindow != 0 ? -9223372036854775807L : 0L);
                if (periodStartPositionUs == -9223372036854775807L) {
                    Pair<Integer, Long> defaultPosition = this.getDefaultPosition(newLoadingPeriodIndex);
                    newLoadingPeriodIndex = (Integer)defaultPosition.first;
                    periodStartPositionUs = (Long)defaultPosition.second;
                }
                Object newPeriodUid = this.timeline.getPeriod((int)newLoadingPeriodIndex, (Timeline.Period)this.period, (boolean)true).uid;
                MediaPeriod newMediaPeriod = this.mediaSource.createPeriod(newLoadingPeriodIndex, this.loadControl.getAllocator(), periodStartPositionUs);
                newMediaPeriod.prepare(this);
                MediaPeriodHolder<T> newPeriodHolder = new MediaPeriodHolder<T>(this.renderers, this.rendererCapabilities, this.trackSelector, this.mediaSource, newMediaPeriod, newPeriodUid, periodStartPositionUs);
                this.timeline.getWindow(windowIndex, this.window);
                newPeriodHolder.setIndex(this.timeline, this.window, newLoadingPeriodIndex);
                if (this.loadingPeriodHolder != null) {
                    this.loadingPeriodHolder.setNext(newPeriodHolder);
                    newPeriodHolder.rendererPositionOffsetUs = this.loadingPeriodHolder.rendererPositionOffsetUs + this.timeline.getPeriod(this.loadingPeriodHolder.index, this.period).getDurationUs();
                }
                ++this.bufferAheadPeriodCount;
                this.loadingPeriodHolder = newPeriodHolder;
                this.setIsLoading(true);
            }
        }
        if (this.loadingPeriodHolder == null || this.loadingPeriodHolder.isFullyBuffered()) {
            this.setIsLoading(false);
        } else if (this.loadingPeriodHolder != null && this.loadingPeriodHolder.needsContinueLoading) {
            this.maybeContinueLoading();
        }
        if (this.playingPeriodHolder == null) {
            return;
        }
        while (this.playingPeriodHolder != this.readingPeriodHolder && this.playingPeriodHolder.next != null && this.rendererPositionUs >= this.playingPeriodHolder.next.rendererPositionOffsetUs) {
            this.playingPeriodHolder.release();
            this.setPlayingPeriodHolder(this.playingPeriodHolder.next);
            --this.bufferAheadPeriodCount;
            this.playbackInfo = new PlaybackInfo(this.playingPeriodHolder.index, this.playingPeriodHolder.startPositionUs);
            this.updatePlaybackPositions();
            this.eventHandler.obtainMessage(4, (Object)this.playbackInfo).sendToTarget();
        }
        this.updateTimelineState();
        if (this.readingPeriodHolder.isLast) {
            for (Renderer renderer : this.enabledRenderers) {
                renderer.setCurrentStreamIsFinal();
            }
            return;
        }
        for (Renderer renderer : this.enabledRenderers) {
            if (renderer.hasReadStreamToEnd()) continue;
            return;
        }
        if (this.readingPeriodHolder.next != null && this.readingPeriodHolder.next.prepared) {
            TrackSelections oldTrackSelections = ((MediaPeriodHolder)this.readingPeriodHolder).trackSelections;
            this.readingPeriodHolder = this.readingPeriodHolder.next;
            TrackSelections newTrackSelections = ((MediaPeriodHolder)this.readingPeriodHolder).trackSelections;
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                TrackSelection oldSelection = oldTrackSelections.get(i);
                TrackSelection newSelection = newTrackSelections.get(i);
                if (oldSelection == null) continue;
                if (newSelection != null) {
                    Format[] formats = new Format[newSelection.length()];
                    for (int j = 0; j < formats.length; ++j) {
                        formats[j] = newSelection.getFormat(j);
                    }
                    renderer.replaceStream(formats, this.readingPeriodHolder.sampleStreams[i], this.readingPeriodHolder.rendererPositionOffsetUs);
                    continue;
                }
                renderer.setCurrentStreamIsFinal();
            }
        }
    }

    private void handlePeriodPrepared(MediaPeriod period) throws ExoPlaybackException {
        if (this.loadingPeriodHolder == null || this.loadingPeriodHolder.mediaPeriod != period) {
            return;
        }
        this.loadingPeriodHolder.handlePrepared(this.loadingPeriodHolder.startPositionUs, this.loadControl);
        if (this.playingPeriodHolder == null) {
            this.readingPeriodHolder = this.loadingPeriodHolder;
            this.setPlayingPeriodHolder(this.readingPeriodHolder);
            if (this.playbackInfo.startPositionUs == -9223372036854775807L) {
                this.playbackInfo = new PlaybackInfo(this.playingPeriodHolder.index, this.playingPeriodHolder.startPositionUs);
                this.resetRendererPosition(this.playbackInfo.startPositionUs);
                this.updatePlaybackPositions();
                this.eventHandler.obtainMessage(4, (Object)this.playbackInfo).sendToTarget();
            }
            this.updateTimelineState();
        }
        this.maybeContinueLoading();
    }

    private void handleContinueLoadingRequested(MediaPeriod period) {
        if (this.loadingPeriodHolder == null || this.loadingPeriodHolder.mediaPeriod != period) {
            return;
        }
        this.maybeContinueLoading();
    }

    private void maybeContinueLoading() {
        long nextLoadPositionUs = this.loadingPeriodHolder.mediaPeriod.getNextLoadPositionUs();
        if (nextLoadPositionUs != Long.MIN_VALUE) {
            long loadingPeriodPositionUs = this.rendererPositionUs - this.loadingPeriodHolder.rendererPositionOffsetUs;
            long bufferedDurationUs = nextLoadPositionUs - loadingPeriodPositionUs;
            boolean continueLoading = this.loadControl.shouldContinueLoading(bufferedDurationUs);
            this.setIsLoading(continueLoading);
            if (continueLoading) {
                this.loadingPeriodHolder.needsContinueLoading = false;
                this.loadingPeriodHolder.mediaPeriod.continueLoading(loadingPeriodPositionUs);
            } else {
                this.loadingPeriodHolder.needsContinueLoading = true;
            }
        } else {
            this.setIsLoading(false);
        }
    }

    private void releasePeriodHoldersFrom(MediaPeriodHolder<T> periodHolder) {
        while (periodHolder != null) {
            periodHolder.release();
            periodHolder = periodHolder.next;
        }
    }

    private void setPlayingPeriodHolder(MediaPeriodHolder<T> periodHolder) throws ExoPlaybackException {
        int enabledRendererCount = 0;
        boolean[] rendererWasEnabledFlags = new boolean[this.renderers.length];
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            rendererWasEnabledFlags[i] = renderer.getState() != 0;
            TrackSelection newSelection = ((MediaPeriodHolder)periodHolder).trackSelections.get(i);
            if (newSelection != null) {
                ++enabledRendererCount;
                continue;
            }
            if (!rendererWasEnabledFlags[i]) continue;
            if (renderer == this.rendererMediaClockSource) {
                this.standaloneMediaClock.setPositionUs(this.rendererMediaClock.getPositionUs());
                this.rendererMediaClock = null;
                this.rendererMediaClockSource = null;
            }
            this.ensureStopped(renderer);
            renderer.disable();
        }
        this.trackSelector.onSelectionActivated(((MediaPeriodHolder)periodHolder).trackSelections);
        this.playingPeriodHolder = periodHolder;
        this.enableRenderers(rendererWasEnabledFlags, enabledRendererCount);
    }

    private void updateTimelineState() {
        long playingPeriodDurationUs = this.timeline.getPeriod(this.playingPeriodHolder.index, this.period).getDurationUs();
        this.isTimelineReady = playingPeriodDurationUs == -9223372036854775807L || this.playbackInfo.positionUs < playingPeriodDurationUs || this.playingPeriodHolder.next != null && this.playingPeriodHolder.next.prepared;
        this.isTimelineEnded = this.playingPeriodHolder.isLast;
    }

    private void enableRenderers(boolean[] rendererWasEnabledFlags, int enabledRendererCount) throws ExoPlaybackException {
        this.enabledRenderers = new Renderer[enabledRendererCount];
        enabledRendererCount = 0;
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            TrackSelection newSelection = ((MediaPeriodHolder)this.playingPeriodHolder).trackSelections.get(i);
            if (newSelection == null) continue;
            this.enabledRenderers[enabledRendererCount++] = renderer;
            if (renderer.getState() != 0) continue;
            boolean playing = this.playWhenReady && this.state == 3;
            boolean joining = !rendererWasEnabledFlags[i] && playing;
            Format[] formats = new Format[newSelection.length()];
            for (int j = 0; j < formats.length; ++j) {
                formats[j] = newSelection.getFormat(j);
            }
            renderer.enable(formats, this.playingPeriodHolder.sampleStreams[i], this.rendererPositionUs, joining, this.playingPeriodHolder.rendererPositionOffsetUs);
            MediaClock mediaClock = renderer.getMediaClock();
            if (mediaClock != null) {
                if (this.rendererMediaClock != null) {
                    throw ExoPlaybackException.createForUnexpected(new IllegalStateException("Multiple renderer media clocks enabled."));
                }
                this.rendererMediaClock = mediaClock;
                this.rendererMediaClockSource = renderer;
            }
            if (!playing) continue;
            renderer.start();
        }
    }

    private static final class MediaPeriodHolder<T> {
        public final MediaPeriod mediaPeriod;
        public final Object uid;
        public final SampleStream[] sampleStreams;
        public final boolean[] mayRetainStreamFlags;
        public int index;
        public long startPositionUs;
        public boolean isLast;
        public boolean prepared;
        public boolean hasEnabledTracks;
        public long rendererPositionOffsetUs;
        public MediaPeriodHolder<T> next;
        public boolean needsContinueLoading;
        private final Renderer[] renderers;
        private final RendererCapabilities[] rendererCapabilities;
        private final TrackSelector<T> trackSelector;
        private final MediaSource mediaSource;
        private TrackSelections<T> trackSelections;
        private TrackSelections<T> periodTrackSelections;

        public MediaPeriodHolder(Renderer[] renderers, RendererCapabilities[] rendererCapabilities, TrackSelector<T> trackSelector, MediaSource mediaSource, MediaPeriod mediaPeriod, Object uid, long positionUs) {
            this.renderers = renderers;
            this.rendererCapabilities = rendererCapabilities;
            this.trackSelector = trackSelector;
            this.mediaSource = mediaSource;
            this.mediaPeriod = mediaPeriod;
            this.uid = Assertions.checkNotNull(uid);
            this.sampleStreams = new SampleStream[renderers.length];
            this.mayRetainStreamFlags = new boolean[renderers.length];
            this.startPositionUs = positionUs;
        }

        public void setNext(MediaPeriodHolder<T> next) {
            this.next = next;
        }

        public void setIndex(Timeline timeline, Timeline.Window window, int periodIndex) {
            this.index = periodIndex;
            this.isLast = this.index == timeline.getPeriodCount() - 1 && !window.isDynamic;
        }

        public boolean isFullyBuffered() {
            return this.prepared && (!this.hasEnabledTracks || this.mediaPeriod.getBufferedPositionUs() == Long.MIN_VALUE);
        }

        public void handlePrepared(long positionUs, LoadControl loadControl) throws ExoPlaybackException {
            this.prepared = true;
            this.selectTracks();
            this.startPositionUs = this.updatePeriodTrackSelection(positionUs, loadControl, false);
        }

        public boolean selectTracks() throws ExoPlaybackException {
            TrackSelections<T> newTrackSelections = this.trackSelector.selectTracks(this.rendererCapabilities, this.mediaPeriod.getTrackGroups());
            if (newTrackSelections.equals(this.periodTrackSelections)) {
                return false;
            }
            this.trackSelections = newTrackSelections;
            return true;
        }

        public long updatePeriodTrackSelection(long positionUs, LoadControl loadControl, boolean forceRecreateStreams) throws ExoPlaybackException {
            return this.updatePeriodTrackSelection(positionUs, loadControl, forceRecreateStreams, new boolean[this.renderers.length]);
        }

        public long updatePeriodTrackSelection(long positionUs, LoadControl loadControl, boolean forceRecreateStreams, boolean[] streamResetFlags) throws ExoPlaybackException {
            int i;
            for (i = 0; i < this.trackSelections.length; ++i) {
                this.mayRetainStreamFlags[i] = !forceRecreateStreams && Util.areEqual(this.periodTrackSelections == null ? null : this.periodTrackSelections.get(i), this.trackSelections.get(i));
            }
            positionUs = this.mediaPeriod.selectTracks(this.trackSelections.getAll(), this.mayRetainStreamFlags, this.sampleStreams, streamResetFlags, positionUs);
            this.periodTrackSelections = this.trackSelections;
            this.hasEnabledTracks = false;
            for (i = 0; i < this.sampleStreams.length; ++i) {
                if (this.sampleStreams[i] != null) {
                    Assertions.checkState(this.trackSelections.get(i) != null);
                    this.hasEnabledTracks = true;
                    continue;
                }
                Assertions.checkState(this.trackSelections.get(i) == null);
            }
            loadControl.onTracksSelected(this.renderers, this.mediaPeriod.getTrackGroups(), this.trackSelections);
            return positionUs;
        }

        public void release() {
            try {
                this.mediaSource.releasePeriod(this.mediaPeriod);
            }
            catch (RuntimeException e) {
                Log.e((String)ExoPlayerImplInternal.TAG, (String)"Period release failed.", (Throwable)e);
            }
        }
    }

    public static final class PlaybackInfo {
        public final int periodIndex;
        public final long startPositionUs;
        public volatile long positionUs;
        public volatile long bufferedPositionUs;

        public PlaybackInfo(int periodIndex, long startPositionUs) {
            this.periodIndex = periodIndex;
            this.startPositionUs = startPositionUs;
            this.positionUs = startPositionUs;
            this.bufferedPositionUs = startPositionUs;
        }
    }
}

