/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImplInternal;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.util.Assertions;
import java.util.concurrent.CopyOnWriteArraySet;

final class ExoPlayerImpl
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    private final Handler eventHandler;
    private final ExoPlayerImplInternal<?> internalPlayer;
    private final CopyOnWriteArraySet<ExoPlayer.EventListener> listeners;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private boolean pendingInitialSeek;
    private boolean playWhenReady;
    private int playbackState;
    private int pendingSeekAcks;
    private boolean isLoading;
    private Timeline timeline;
    private Object manifest;
    private ExoPlayerImplInternal.PlaybackInfo playbackInfo;
    private int maskingWindowIndex;
    private long maskingWindowPositionMs;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(Renderer[] renderers, TrackSelector<?> trackSelector, LoadControl loadControl) {
        Log.i((String)TAG, (String)"Init 2.0.4");
        Assertions.checkNotNull(renderers);
        Assertions.checkState(renderers.length > 0);
        this.playWhenReady = false;
        this.playbackState = 1;
        this.listeners = new CopyOnWriteArraySet();
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.eventHandler = new Handler(){

            public void handleMessage(Message msg) {
                ExoPlayerImpl.this.handleEvent(msg);
            }
        };
        this.playbackInfo = new ExoPlayerImplInternal.PlaybackInfo(0, 0L);
        this.internalPlayer = new ExoPlayerImplInternal(renderers, trackSelector, loadControl, this.playWhenReady, this.eventHandler, this.playbackInfo);
    }

    @Override
    public void addListener(ExoPlayer.EventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExoPlayer.EventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getPlaybackState() {
        return this.playbackState;
    }

    @Override
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Override
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetTimeline) {
        if (resetTimeline && (this.timeline != null || this.manifest != null)) {
            this.timeline = null;
            this.manifest = null;
            for (ExoPlayer.EventListener listener : this.listeners) {
                listener.onTimelineChanged(null, null);
            }
        }
        this.internalPlayer.prepare(mediaSource, resetPosition);
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        if (this.playWhenReady != playWhenReady) {
            this.playWhenReady = playWhenReady;
            this.internalPlayer.setPlayWhenReady(playWhenReady);
            for (ExoPlayer.EventListener listener : this.listeners) {
                listener.onPlayerStateChanged(playWhenReady, this.playbackState);
            }
        }
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.playWhenReady;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public void seekToDefaultPosition() {
        this.seekToDefaultPosition(this.getCurrentWindowIndex());
    }

    @Override
    public void seekToDefaultPosition(int windowIndex) {
        if (this.timeline == null) {
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = -9223372036854775807L;
            this.pendingInitialSeek = true;
        } else {
            Assertions.checkIndex(windowIndex, 0, this.timeline.getWindowCount());
            ++this.pendingSeekAcks;
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = 0L;
            this.internalPlayer.seekTo(this.timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).firstPeriodIndex, -9223372036854775807L);
        }
    }

    @Override
    public void seekTo(long positionMs) {
        this.seekTo(this.getCurrentWindowIndex(), positionMs);
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        if (positionMs == -9223372036854775807L) {
            this.seekToDefaultPosition(windowIndex);
        } else if (this.timeline == null) {
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = positionMs;
            this.pendingInitialSeek = true;
        } else {
            long periodPositionMs;
            Assertions.checkIndex(windowIndex, 0, this.timeline.getWindowCount());
            ++this.pendingSeekAcks;
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = positionMs;
            this.timeline.getWindow(windowIndex, this.window);
            int periodIndex = this.window.firstPeriodIndex;
            long periodDurationMs = this.timeline.getPeriod(periodIndex, this.period).getDurationMs();
            for (periodPositionMs = this.window.getPositionInFirstPeriodMs() + positionMs; periodDurationMs != -9223372036854775807L && periodPositionMs >= periodDurationMs && periodIndex < this.window.lastPeriodIndex; periodPositionMs -= periodDurationMs) {
                periodDurationMs = this.timeline.getPeriod(++periodIndex, this.period).getDurationMs();
            }
            this.internalPlayer.seekTo(periodIndex, C.msToUs(periodPositionMs));
            for (ExoPlayer.EventListener listener : this.listeners) {
                listener.onPositionDiscontinuity();
            }
        }
    }

    @Override
    public void stop() {
        this.internalPlayer.stop();
    }

    @Override
    public void release() {
        this.internalPlayer.release();
        this.eventHandler.removeCallbacksAndMessages(null);
    }

    @Override
    public void sendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.internalPlayer.sendMessages(messages);
    }

    @Override
    public void blockingSendMessages(ExoPlayer.ExoPlayerMessage ... messages) {
        this.internalPlayer.blockingSendMessages(messages);
    }

    @Override
    public int getCurrentPeriodIndex() {
        return this.playbackInfo.periodIndex;
    }

    @Override
    public int getCurrentWindowIndex() {
        if (this.timeline == null || this.pendingSeekAcks > 0) {
            return this.maskingWindowIndex;
        }
        return this.timeline.getPeriod((int)this.playbackInfo.periodIndex, (Timeline.Period)this.period).windowIndex;
    }

    @Override
    public long getDuration() {
        if (this.timeline == null) {
            return -9223372036854775807L;
        }
        return this.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
    }

    @Override
    public long getCurrentPosition() {
        if (this.timeline == null || this.pendingSeekAcks > 0) {
            return this.maskingWindowPositionMs;
        }
        this.timeline.getPeriod(this.playbackInfo.periodIndex, this.period);
        return this.period.getPositionInWindowMs() + C.usToMs(this.playbackInfo.positionUs);
    }

    @Override
    public long getBufferedPosition() {
        if (this.timeline == null || this.pendingSeekAcks > 0) {
            return this.maskingWindowPositionMs;
        }
        this.timeline.getPeriod(this.playbackInfo.periodIndex, this.period);
        return this.period.getPositionInWindowMs() + C.usToMs(this.playbackInfo.bufferedPositionUs);
    }

    @Override
    public int getBufferedPercentage() {
        if (this.timeline == null) {
            return 0;
        }
        long bufferedPosition = this.getBufferedPosition();
        long duration = this.getDuration();
        return bufferedPosition == -9223372036854775807L || duration == -9223372036854775807L ? 0 : (int)(duration == 0L ? 100L : bufferedPosition * 100L / duration);
    }

    @Override
    public Timeline getCurrentTimeline() {
        return this.timeline;
    }

    @Override
    public Object getCurrentManifest() {
        return this.manifest;
    }

    void handleEvent(Message msg) {
        switch (msg.what) {
            case 1: {
                this.playbackState = msg.arg1;
                for (ExoPlayer.EventListener listener : this.listeners) {
                    listener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
                }
                break;
            }
            case 2: {
                this.isLoading = msg.arg1 != 0;
                for (ExoPlayer.EventListener listener : this.listeners) {
                    listener.onLoadingChanged(this.isLoading);
                }
                break;
            }
            case 3: {
                if (--this.pendingSeekAcks != 0) break;
                this.playbackInfo = (ExoPlayerImplInternal.PlaybackInfo)msg.obj;
                for (ExoPlayer.EventListener listener : this.listeners) {
                    listener.onPositionDiscontinuity();
                }
                break;
            }
            case 4: {
                if (this.pendingSeekAcks != 0) break;
                this.playbackInfo = (ExoPlayerImplInternal.PlaybackInfo)msg.obj;
                for (ExoPlayer.EventListener listener : this.listeners) {
                    listener.onPositionDiscontinuity();
                }
                break;
            }
            case 5: {
                Pair timelineAndManifest = (Pair)msg.obj;
                this.timeline = (Timeline)timelineAndManifest.first;
                this.manifest = timelineAndManifest.second;
                if (this.pendingInitialSeek) {
                    this.pendingInitialSeek = false;
                    this.seekTo(this.maskingWindowIndex, this.maskingWindowPositionMs);
                }
                for (ExoPlayer.EventListener listener : this.listeners) {
                    listener.onTimelineChanged(this.timeline, this.manifest);
                }
                break;
            }
            case 6: {
                ExoPlaybackException exception = (ExoPlaybackException)msg.obj;
                for (ExoPlayer.EventListener listener : this.listeners) {
                    listener.onPlayerError(exception);
                }
                break;
            }
        }
    }
}

