/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;

public interface ExoPlayer {
    public static final int STATE_IDLE = 1;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_ENDED = 4;

    public void addListener(EventListener var1);

    public void removeListener(EventListener var1);

    public int getPlaybackState();

    public void prepare(MediaSource var1);

    public void prepare(MediaSource var1, boolean var2, boolean var3);

    public void setPlayWhenReady(boolean var1);

    public boolean getPlayWhenReady();

    public boolean isLoading();

    public void seekToDefaultPosition();

    public void seekToDefaultPosition(int var1);

    public void seekTo(long var1);

    public void seekTo(int var1, long var2);

    public void stop();

    public void release();

    public void sendMessages(ExoPlayerMessage ... var1);

    public void blockingSendMessages(ExoPlayerMessage ... var1);

    public Object getCurrentManifest();

    public Timeline getCurrentTimeline();

    public int getCurrentPeriodIndex();

    public int getCurrentWindowIndex();

    public long getDuration();

    public long getCurrentPosition();

    public long getBufferedPosition();

    public int getBufferedPercentage();

    public static final class ExoPlayerMessage {
        public final ExoPlayerComponent target;
        public final int messageType;
        public final Object message;

        public ExoPlayerMessage(ExoPlayerComponent target, int messageType, Object message) {
            this.target = target;
            this.messageType = messageType;
            this.message = message;
        }
    }

    public static interface ExoPlayerComponent {
        public void handleMessage(int var1, Object var2) throws ExoPlaybackException;
    }

    public static interface EventListener {
        public void onLoadingChanged(boolean var1);

        public void onPlayerStateChanged(boolean var1, int var2);

        public void onTimelineChanged(Timeline var1, Object var2);

        public void onPlayerError(ExoPlaybackException var1);

        public void onPositionDiscontinuity();
    }
}

