/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelections;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DefaultAllocator;
import com.google.android.exoplayer2.util.Util;

public final class DefaultLoadControl
implements LoadControl {
    public static final int DEFAULT_MIN_BUFFER_MS = 15000;
    public static final int DEFAULT_MAX_BUFFER_MS = 30000;
    public static final int DEFAULT_BUFFER_FOR_PLAYBACK_MS = 2500;
    public static final int DEFAULT_BUFFER_FOR_PLAYBACK_AFTER_REBUFFER_MS = 5000;
    private static final int ABOVE_HIGH_WATERMARK = 0;
    private static final int BETWEEN_WATERMARKS = 1;
    private static final int BELOW_LOW_WATERMARK = 2;
    private final DefaultAllocator allocator;
    private final long minBufferUs;
    private final long maxBufferUs;
    private final long bufferForPlaybackUs;
    private final long bufferForPlaybackAfterRebufferUs;
    private int targetBufferSize;
    private boolean isBuffering;

    public DefaultLoadControl() {
        this(new DefaultAllocator(true, 65536));
    }

    public DefaultLoadControl(DefaultAllocator allocator) {
        this(allocator, 15000, 30000, 2500L, 5000L);
    }

    public DefaultLoadControl(DefaultAllocator allocator, int minBufferMs, int maxBufferMs, long bufferForPlaybackMs, long bufferForPlaybackAfterRebufferMs) {
        this.allocator = allocator;
        this.minBufferUs = (long)minBufferMs * 1000L;
        this.maxBufferUs = (long)maxBufferMs * 1000L;
        this.bufferForPlaybackUs = bufferForPlaybackMs * 1000L;
        this.bufferForPlaybackAfterRebufferUs = bufferForPlaybackAfterRebufferMs * 1000L;
    }

    @Override
    public void onPrepared() {
        this.reset(false);
    }

    @Override
    public void onTracksSelected(Renderer[] renderers, TrackGroupArray trackGroups, TrackSelections<?> trackSelections) {
        this.targetBufferSize = 0;
        for (int i = 0; i < renderers.length; ++i) {
            if (trackSelections.get(i) == null) continue;
            this.targetBufferSize += Util.getDefaultBufferSize(renderers[i].getTrackType());
        }
        this.allocator.setTargetBufferSize(this.targetBufferSize);
    }

    @Override
    public void onStopped() {
        this.reset(true);
    }

    @Override
    public void onReleased() {
        this.reset(true);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public boolean shouldStartPlayback(long bufferedDurationUs, boolean rebuffering) {
        long minBufferDurationUs = rebuffering ? this.bufferForPlaybackAfterRebufferUs : this.bufferForPlaybackUs;
        return minBufferDurationUs <= 0L || bufferedDurationUs >= minBufferDurationUs;
    }

    @Override
    public boolean shouldContinueLoading(long bufferedDurationUs) {
        int bufferTimeState = this.getBufferTimeState(bufferedDurationUs);
        boolean targetBufferSizeReached = this.allocator.getTotalBytesAllocated() >= this.targetBufferSize;
        this.isBuffering = bufferTimeState == 2 || bufferTimeState == 1 && this.isBuffering && !targetBufferSizeReached;
        return this.isBuffering;
    }

    private int getBufferTimeState(long bufferedDurationUs) {
        return bufferedDurationUs > this.maxBufferUs ? 0 : (bufferedDurationUs < this.minBufferUs ? 2 : 1);
    }

    private void reset(boolean resetAllocator) {
        this.targetBufferSize = 0;
        this.isBuffering = false;
        if (resetAllocator) {
            this.allocator.reset();
        }
    }
}

