/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaClock;
import java.io.IOException;

public abstract class BaseRenderer
implements Renderer,
RendererCapabilities {
    private final int trackType;
    private int index;
    private int state;
    private SampleStream stream;
    private long streamOffsetUs;
    private boolean readEndOfStream;
    private boolean streamIsFinal;

    public BaseRenderer(int trackType) {
        this.trackType = trackType;
        this.readEndOfStream = true;
    }

    @Override
    public final int getTrackType() {
        return this.trackType;
    }

    @Override
    public final RendererCapabilities getCapabilities() {
        return this;
    }

    @Override
    public final void setIndex(int index) {
        this.index = index;
    }

    @Override
    public MediaClock getMediaClock() {
        return null;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final void enable(Format[] formats, SampleStream stream, long positionUs, boolean joining, long offsetUs) throws ExoPlaybackException {
        Assertions.checkState(this.state == 0);
        this.state = 1;
        this.onEnabled(joining);
        this.replaceStream(formats, stream, offsetUs);
        this.onPositionReset(positionUs, joining);
    }

    @Override
    public final void start() throws ExoPlaybackException {
        Assertions.checkState(this.state == 1);
        this.state = 2;
        this.onStarted();
    }

    @Override
    public final void replaceStream(Format[] formats, SampleStream stream, long offsetUs) throws ExoPlaybackException {
        Assertions.checkState(!this.streamIsFinal);
        this.stream = stream;
        this.readEndOfStream = false;
        this.streamOffsetUs = offsetUs;
        this.onStreamChanged(formats);
    }

    @Override
    public final SampleStream getStream() {
        return this.stream;
    }

    @Override
    public final boolean hasReadStreamToEnd() {
        return this.readEndOfStream;
    }

    @Override
    public final void setCurrentStreamIsFinal() {
        this.streamIsFinal = true;
    }

    @Override
    public final void maybeThrowStreamError() throws IOException {
        this.stream.maybeThrowError();
    }

    @Override
    public final void resetPosition(long positionUs) throws ExoPlaybackException {
        this.streamIsFinal = false;
        this.onPositionReset(positionUs, false);
    }

    @Override
    public final void stop() throws ExoPlaybackException {
        Assertions.checkState(this.state == 2);
        this.state = 1;
        this.onStopped();
    }

    @Override
    public final void disable() {
        Assertions.checkState(this.state == 1);
        this.state = 0;
        this.onDisabled();
        this.stream = null;
        this.streamIsFinal = false;
    }

    @Override
    public int supportsMixedMimeTypeAdaptation() throws ExoPlaybackException {
        return 0;
    }

    @Override
    public void handleMessage(int what, Object object) throws ExoPlaybackException {
    }

    protected void onEnabled(boolean joining) throws ExoPlaybackException {
    }

    protected void onStreamChanged(Format[] formats) throws ExoPlaybackException {
    }

    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
    }

    protected void onStarted() throws ExoPlaybackException {
    }

    protected void onStopped() throws ExoPlaybackException {
    }

    protected void onDisabled() {
    }

    protected final int getIndex() {
        return this.index;
    }

    protected final int readSource(FormatHolder formatHolder, DecoderInputBuffer buffer) {
        int result = this.stream.readData(formatHolder, buffer);
        if (result == -4) {
            if (buffer.isEndOfStream()) {
                this.readEndOfStream = true;
                return this.streamIsFinal ? -4 : -3;
            }
            buffer.timeUs += this.streamOffsetUs;
        }
        return result;
    }

    protected final boolean isSourceReady() {
        return this.readEndOfStream ? this.streamIsFinal : this.stream.isReady();
    }

    protected void skipToKeyframeBefore(long timeUs) {
        this.stream.skipToKeyframeBefore(timeUs);
    }
}

